/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client;

import java.lang.annotation.Annotation;
import org.guvnor.common.services.project.client.ArtifactIdChangeHandler;
import org.guvnor.common.services.project.client.GroupIdChangeHandler;
import org.guvnor.common.services.project.client.POMEditorPanel;
import org.guvnor.common.services.project.client.POMEditorPanelView;
import org.guvnor.common.services.project.client.VersionChangeHandler;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;

@RunWith(value=MockitoJUnitRunner.class)
public class POMEditorPanelTest {
    @Mock
    private POMEditorPanelView view;
    @Mock
    private SyncBeanManager iocManager;
    private POMEditorPanel panel;
    private POMEditorPanelView.Presenter presenter;

    @Before
    public void setUp() throws Exception {
        this.panel = new POMEditorPanel(this.view, this.iocManager);
        this.presenter = this.panel;
        ((POMEditorPanelView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPresenter(this.presenter);
    }

    @Test
    public void testAddArtifactChangeHandler() {
        ArtifactIdChangeHandler handler = (ArtifactIdChangeHandler)Mockito.mock(ArtifactIdChangeHandler.class);
        this.panel.addArtifactIdChangeHandler(handler);
        ((POMEditorPanelView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addArtifactIdChangeHandler(handler);
    }

    @Test
    public void testAddGroupChangeHandler() {
        GroupIdChangeHandler handler = (GroupIdChangeHandler)Mockito.mock(GroupIdChangeHandler.class);
        this.panel.addGroupIdChangeHandler(handler);
        ((POMEditorPanelView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addGroupIdChangeHandler(handler);
    }

    @Test
    public void testAddVersionChangeHandler() {
        VersionChangeHandler handler = (VersionChangeHandler)Mockito.mock(VersionChangeHandler.class);
        this.panel.addVersionChangeHandler(handler);
        ((POMEditorPanelView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addVersionChangeHandler(handler);
    }

    @Test
    public void testLoadSingleModule() throws Exception {
        POM gavModel = this.createTestModel("pomName", "pomDescription", "group", "artifact", "1.1.1");
        this.panel.setPOM(gavModel, false);
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).setName("pomName");
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).setDescription("pomDescription");
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).enableGroupID();
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).enableArtifactID();
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).enableVersion();
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).hideParentGAV();
    }

    @Test
    public void testLoadMultiModule() throws Exception {
        POM gavModel = this.createTestModel("group", "artifact", "1.1.1");
        gavModel.setParent(new GAV("org.parent", "parent", "1.1.1"));
        this.panel.setPOM(gavModel, false);
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).setGAV(gavModel.getGav());
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).setTitleText("artifact");
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).setParentGAV(gavModel.getParent());
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).disableGroupID("");
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).enableArtifactID();
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).disableVersion("");
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).showParentGAV();
    }

    @Test
    public void testProjectNameValidation() throws Exception {
        this.panel.setValidName(true);
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).setValidName(true);
        this.panel.setValidName(false);
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).setValidName(false);
    }

    @Test
    public void testGroupIDValidation() throws Exception {
        this.panel.setValidGroupID(true);
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).setValidGroupID(true);
        this.panel.setValidGroupID(false);
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).setValidGroupID(false);
    }

    @Test
    public void testArtifactIDValidation() throws Exception {
        this.panel.setValidArtifactID(true);
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).setValidArtifactID(true);
        this.panel.setValidArtifactID(false);
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).setValidArtifactID(false);
    }

    @Test
    public void testVersionValidation() throws Exception {
        this.panel.setValidVersion(true);
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).setValidVersion(true);
        this.panel.setValidVersion(false);
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).setValidVersion(false);
    }

    @Test
    public void testOpenProjectContext() throws Exception {
        SyncBeanDef iocBeanDef = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        PlaceManager placeManager = (PlaceManager)Mockito.mock(PlaceManager.class);
        Mockito.when((Object)iocBeanDef.getInstance()).thenReturn((Object)placeManager);
        Mockito.when((Object)this.iocManager.lookupBean((Class)Mockito.eq(PlaceManager.class), new Annotation[0])).thenReturn((Object)iocBeanDef);
        this.presenter.onOpenProjectContext();
        ((PlaceManager)Mockito.verify((Object)placeManager)).goTo("repositoryStructureScreen");
    }

    private POM createTestModel(String group, String artifact, String version) {
        return new POM(new GAV(group, artifact, version));
    }

    private POM createTestModel(String name, String description, String group, String artifact, String version) {
        return new POM(name, description, new GAV(group, artifact, version));
    }
}

