/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.resources.ProjectResources;
import org.guvnor.common.services.project.client.resources.i18n.ProjectConstants;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.security.ProjectAction;
import org.guvnor.common.services.project.service.ProjectSearchService;
import org.jboss.errai.common.client.api.Caller;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.client.authz.tree.LoadCallback;
import org.uberfire.security.client.authz.tree.LoadOptions;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.PermissionTreeProvider;
import org.uberfire.security.client.authz.tree.impl.PermissionLeafNode;
import org.uberfire.security.client.authz.tree.impl.PermissionResourceNode;

@ApplicationScoped
public class ProjectTreeProvider
implements PermissionTreeProvider {
    private ProjectConstants i18n = ProjectResources.CONSTANTS;
    private PermissionManager permissionManager;
    private int rootNodePosition = 0;
    private Caller<ProjectSearchService> searchService;

    public ProjectTreeProvider() {
    }

    @Inject
    public ProjectTreeProvider(PermissionManager permissionManager, Caller<ProjectSearchService> searchService) {
        this.permissionManager = permissionManager;
        this.searchService = searchService;
    }

    public int getRootNodePosition() {
        return this.rootNodePosition;
    }

    public void setRootNodePosition(int rootNodePosition) {
        this.rootNodePosition = rootNodePosition;
    }

    public PermissionNode buildRootNode() {
        PermissionResourceNode rootNode = new PermissionResourceNode(this.i18n.ProjectResource(), (PermissionTreeProvider)this);
        rootNode.setNodeName(this.i18n.ProjectsNode());
        rootNode.setPositionInTree(this.rootNodePosition);
        rootNode.addPermission(this.newPermission(ProjectAction.READ), this.i18n.ProjectActionRead());
        rootNode.addPermission(this.newPermission((ResourceAction)ProjectAction.UPDATE), this.i18n.ProjectActionUpdate());
        rootNode.addPermission(this.newPermission((ResourceAction)ProjectAction.DELETE), this.i18n.ProjectActionDelete());
        rootNode.addPermission(this.newPermission((ResourceAction)ProjectAction.BUILD), this.i18n.ProjectActionBuild());
        rootNode.addPermission(this.newPermission((ResourceAction)ProjectAction.CREATE), this.i18n.ProjectActionCreate());
        return rootNode;
    }

    private Permission newPermission(ResourceAction action) {
        return this.permissionManager.createPermission((ResourceType)Project.RESOURCE_TYPE, action, true);
    }

    private Permission newPermission(Resource resource, ResourceAction action) {
        return this.permissionManager.createPermission(resource, action, true);
    }

    public void loadChildren(PermissionNode parent, LoadOptions options, LoadCallback callback) {
        Collection resourceIds = options.getResourceIds();
        int maxNodes = options.getMaxNodes();
        if (this.searchService != null) {
            if (resourceIds != null) {
                ((ProjectSearchService)this.searchService.call(projects -> {
                    List<PermissionNode> children = this.buildPermissionNodes((Collection<Project>)projects);
                    callback.afterLoad(children);
                })).searchById(resourceIds);
            } else {
                String namePattern = options.getNodeNamePattern();
                ((ProjectSearchService)this.searchService.call(projects -> {
                    List<PermissionNode> children = this.buildPermissionNodes((Collection<Project>)projects);
                    callback.afterLoad(children);
                })).searchByName(namePattern, maxNodes, false);
            }
        } else {
            callback.afterLoad(Collections.emptyList());
        }
    }

    private List<PermissionNode> buildPermissionNodes(Collection<Project> projects) {
        ArrayList<PermissionNode> nodes = new ArrayList<PermissionNode>();
        for (Project p : projects) {
            nodes.add(this.toPermissionNode(p));
        }
        return nodes;
    }

    private PermissionNode toPermissionNode(Project p) {
        PermissionLeafNode node = new PermissionLeafNode();
        node.setNodeName(p.getProjectName());
        node.addPermission(this.newPermission((Resource)p, ProjectAction.READ), this.i18n.ProjectActionRead());
        node.addPermission(this.newPermission((Resource)p, (ResourceAction)ProjectAction.UPDATE), this.i18n.ProjectActionUpdate());
        node.addPermission(this.newPermission((Resource)p, (ResourceAction)ProjectAction.DELETE), this.i18n.ProjectActionDelete());
        node.addPermission(this.newPermission((Resource)p, (ResourceAction)ProjectAction.BUILD), this.i18n.ProjectActionBuild());
        return node;
    }
}

