/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.guvnor.common.services.project.client.ArtifactIdChangeHandler;
import org.guvnor.common.services.project.client.GAVEditor;
import org.guvnor.common.services.project.client.GAVEditorView;
import org.guvnor.common.services.project.client.GAVEditorViewImpl;
import org.guvnor.common.services.project.client.GroupIdChangeHandler;
import org.guvnor.common.services.project.client.VersionChangeHandler;
import org.guvnor.common.services.project.model.GAV;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class GAVEditorTest {
    @Mock
    GroupIdChangeHandler groupIdChangeHandler;
    @Mock
    ArtifactIdChangeHandler artifactIdChangeHandler;
    @Mock
    VersionChangeHandler versionChangeHandler;
    @GwtMock
    GAVEditorViewImpl view;
    private GAVEditor editor;
    private GAV gav;

    @Before
    public void setUp() throws Exception {
        this.editor = new GAVEditor((GAVEditorView)this.view);
        ((GAVEditorViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPresenter((GAVEditorView.Presenter)this.editor);
        this.gav = new GAV("groupId", "artifactId", "version");
    }

    @Test
    public void testSetGav() {
        this.editor.setGAV(this.gav);
        ((GAVEditorViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setGroupId(this.gav.getGroupId());
        ((GAVEditorViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setArtifactId(this.gav.getArtifactId());
        ((GAVEditorViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setVersion(this.gav.getVersion());
    }

    @Test
    public void testSetArtifactID() throws Exception {
        this.editor.setGAV(this.gav);
        this.editor.setArtifactID("changed");
        ((GAVEditorViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setArtifactId((String)Mockito.eq((Object)"changed"));
        Assert.assertEquals((Object)"changed", (Object)this.gav.getArtifactId());
    }

    @Test
    public void testGroupChangeHandler() {
        this.editor.addGroupIdChangeHandler(this.groupIdChangeHandler);
        this.editor.setGAV(this.gav);
        this.editor.onGroupIdChange("changedGroup");
        ((GroupIdChangeHandler)Mockito.verify((Object)this.groupIdChangeHandler, (VerificationMode)Mockito.times((int)1))).onChange("changedGroup");
        Assert.assertEquals((Object)"changedGroup", (Object)this.gav.getGroupId());
    }

    @Test
    public void testArtifactChangeHandler() {
        this.editor.addArtifactIdChangeHandler(this.artifactIdChangeHandler);
        this.editor.setGAV(this.gav);
        this.editor.onArtifactIdChange("artifactChanged");
        ((ArtifactIdChangeHandler)Mockito.verify((Object)this.artifactIdChangeHandler, (VerificationMode)Mockito.times((int)1))).onChange("artifactChanged");
        Assert.assertEquals((Object)"artifactChanged", (Object)this.gav.getArtifactId());
    }

    @Test
    public void testVersionChangeHandler() {
        this.editor.addVersionChangeHandler(this.versionChangeHandler);
        this.editor.setGAV(this.gav);
        this.editor.onVersionChange("versionChanged");
        ((VersionChangeHandler)Mockito.verify((Object)this.versionChangeHandler, (VerificationMode)Mockito.times((int)1))).onChange("versionChanged");
        Assert.assertEquals((Object)"versionChanged", (Object)this.gav.getVersion());
    }
}

