/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client.preferences;

import org.guvnor.common.services.project.client.preferences.ProjectScopedResolutionStrategySupplier;
import org.guvnor.common.services.project.context.ProjectContextChangeEvent;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.shared.preferences.WorkbenchPreferenceScopeResolutionStrategies;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;

@RunWith(value=MockitoJUnitRunner.class)
public class ProjectScopedResolutionStrategySupplierTest {
    @Mock
    private WorkbenchPreferenceScopeResolutionStrategies scopeResolutionStrategies;
    private ProjectScopedResolutionStrategySupplier projectScopedResolutionStrategySupplier;
    private Project project;

    @Before
    public void setup() {
        this.projectScopedResolutionStrategySupplier = (ProjectScopedResolutionStrategySupplier)Mockito.spy((Object)new ProjectScopedResolutionStrategySupplier(this.scopeResolutionStrategies));
        this.project = (Project)Mockito.mock(Project.class);
        ((Project)Mockito.doReturn((Object)"projectIdentifier").when((Object)this.project)).getIdentifier();
        ((Project)Mockito.doReturn((Object)"projectIdentifierEncoded").when((Object)this.project)).getEncodedIdentifier();
    }

    @Test
    public void getWithoutProjectTest() {
        PreferenceScopeResolutionStrategyInfo preferenceScopeResolutionStrategyInfo = this.projectScopedResolutionStrategySupplier.get();
        ((WorkbenchPreferenceScopeResolutionStrategies)Mockito.verify((Object)this.scopeResolutionStrategies)).getUserInfoFor(null, null);
    }

    @Test
    public void getWithProjectTest() {
        ProjectContextChangeEvent event = (ProjectContextChangeEvent)Mockito.mock(ProjectContextChangeEvent.class);
        ((ProjectContextChangeEvent)Mockito.doReturn((Object)this.project).when((Object)event)).getProject();
        this.projectScopedResolutionStrategySupplier.selectedProjectChanged(event);
        PreferenceScopeResolutionStrategyInfo preferenceScopeResolutionStrategyInfo = this.projectScopedResolutionStrategySupplier.get();
        ((WorkbenchPreferenceScopeResolutionStrategies)Mockito.verify((Object)this.scopeResolutionStrategies)).getUserInfoFor("project", "projectIdentifierEncoded");
    }
}

