/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import org.guvnor.common.services.project.client.GAVEditorView;
import org.guvnor.common.services.project.client.resources.ProjectResources;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ValidationState;

public class GAVEditorViewImpl
extends Composite
implements GAVEditorView {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @UiField
    FormGroup groupIdGroup;
    @UiField
    TextBox groupIdTextBox;
    @UiField
    HelpBlock groupIdHelpBlock;
    @UiField
    FormGroup artifactIdGroup;
    @UiField
    TextBox artifactIdTextBox;
    @UiField
    HelpBlock artifactIdHelpBlock;
    @UiField
    FormGroup versionGroup;
    @UiField
    TextBox versionTextBox;
    @UiField
    HelpBlock versionHelpBlock;
    private GAVEditorView.Presenter presenter;

    public GAVEditorViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    @Override
    public void setPresenter(GAVEditorView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setGroupId(String id) {
        this.groupIdTextBox.setText(id);
    }

    @Override
    public void setArtifactId(String id) {
        this.artifactIdTextBox.setText(id);
    }

    @Override
    public void setVersion(String version) {
        this.versionTextBox.setText(version);
    }

    @Override
    public void disableGroupID(String reason) {
        this.groupIdTextBox.setEnabled(false);
        this.groupIdTextBox.setTitle(reason);
    }

    @Override
    public void disableArtifactID(String reason) {
        this.artifactIdTextBox.setEnabled(false);
        this.artifactIdTextBox.setTitle(reason);
    }

    @Override
    public void disableVersion(String reason) {
        this.versionTextBox.setEnabled(false);
        this.versionTextBox.setTitle(reason);
    }

    @Override
    public void setReadOnly() {
        this.groupIdTextBox.setReadOnly(true);
        this.artifactIdTextBox.setReadOnly(true);
        this.versionTextBox.setReadOnly(true);
    }

    @Override
    public void enableGroupID() {
        this.groupIdTextBox.setEnabled(true);
        this.groupIdTextBox.setTitle("");
    }

    @Override
    public void enableArtifactID() {
        this.artifactIdTextBox.setEnabled(true);
        this.artifactIdTextBox.setTitle("");
    }

    @Override
    public void enableVersion() {
        this.versionTextBox.setEnabled(true);
        this.versionTextBox.setTitle("");
    }

    @Override
    public void setValidGroupID(boolean isValid) {
        if (isValid) {
            this.groupIdGroup.setValidationState(ValidationState.NONE);
            this.groupIdHelpBlock.setText("");
        } else {
            this.groupIdGroup.setValidationState(ValidationState.ERROR);
            this.groupIdHelpBlock.setText(ProjectResources.CONSTANTS.invalidGroupId());
        }
    }

    @Override
    public void setValidArtifactID(boolean isValid) {
        if (isValid) {
            this.artifactIdGroup.setValidationState(ValidationState.NONE);
            this.artifactIdHelpBlock.setText("");
        } else {
            this.artifactIdGroup.setValidationState(ValidationState.ERROR);
            this.artifactIdHelpBlock.setText(ProjectResources.CONSTANTS.invalidArtifactId());
        }
    }

    @Override
    public void setValidVersion(boolean isValid) {
        if (isValid) {
            this.versionGroup.setValidationState(ValidationState.NONE);
            this.versionHelpBlock.setText("");
        } else {
            this.versionGroup.setValidationState(ValidationState.ERROR);
            this.versionHelpBlock.setText(ProjectResources.CONSTANTS.invalidVersion());
        }
    }

    @UiHandler(value={"groupIdTextBox"})
    public void onGroupIdChange(KeyUpEvent event) {
        this.presenter.onGroupIdChange(this.groupIdTextBox.getText());
    }

    @UiHandler(value={"artifactIdTextBox"})
    public void onArtifactIdChange(KeyUpEvent event) {
        this.presenter.onArtifactIdChange(this.artifactIdTextBox.getText());
    }

    @UiHandler(value={"versionTextBox"})
    public void onVersionChange(KeyUpEvent event) {
        this.presenter.onVersionChange(this.versionTextBox.getText());
    }

    static interface Binder
    extends UiBinder<Widget, GAVEditorViewImpl> {
    }
}

