/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client.security;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.guvnor.common.services.project.client.security.ProjectTreeProvider;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectSearchService;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.CallerMock;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.PermissionTree;
import org.uberfire.security.impl.authz.DefaultPermissionManager;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProjectTreeProviderTest {
    @Mock
    ProjectSearchService searchService;
    @Mock
    PermissionTree permissionTree;
    @Mock
    Project project1;
    @Mock
    Project project2;
    PermissionManager permissionManager;
    ProjectTreeProvider treeProvider;
    PermissionNode rootNode;

    @Before
    public void setup() {
        this.permissionManager = new DefaultPermissionManager();
        this.treeProvider = new ProjectTreeProvider(this.permissionManager, (Caller)new CallerMock((Object)this.searchService));
        this.rootNode = this.treeProvider.buildRootNode();
        this.rootNode.setPermissionTree(this.permissionTree);
        Mockito.when((Object)this.project1.getIdentifier()).thenReturn((Object)"p1");
        Mockito.when((Object)this.project2.getIdentifier()).thenReturn((Object)"p2");
        Mockito.when((Object)this.project1.getProjectName()).thenReturn((Object)"p1");
        Mockito.when((Object)this.project2.getProjectName()).thenReturn((Object)"p2");
        Mockito.when((Object)this.project1.getResourceType()).thenReturn((Object)Project.RESOURCE_TYPE);
        Mockito.when((Object)this.project2.getResourceType()).thenReturn((Object)Project.RESOURCE_TYPE);
        Mockito.when((Object)this.permissionTree.getChildrenResourceIds((PermissionNode)Mockito.any())).thenReturn(null);
        Mockito.when((Object)this.searchService.searchByName(Mockito.anyString(), Mockito.anyInt(), Mockito.anyBoolean())).thenReturn(Arrays.asList(this.project1, this.project2));
    }

    @Test
    public void testRootNode() {
        Assert.assertEquals((long)this.rootNode.getPermissionList().size(), (long)5L);
        this.checkDependencies(this.rootNode);
    }

    @Test
    public void testChildrenNodes() {
        this.rootNode.expand(children -> {
            ((ProjectSearchService)Mockito.verify((Object)this.searchService)).searchByName(Mockito.anyString(), Mockito.anyInt(), Mockito.anyBoolean());
            for (PermissionNode child : children) {
                List permissionList = child.getPermissionList();
                Assert.assertEquals((long)permissionList.size(), (long)4L);
                this.checkDependencies(child);
                List permissionNames = permissionList.stream().map(Permission::getName).collect(Collectors.toList());
                Assert.assertTrue((boolean)permissionNames.contains("project.read." + child.getNodeName()));
                Assert.assertTrue((boolean)permissionNames.contains("project.update." + child.getNodeName()));
                Assert.assertTrue((boolean)permissionNames.contains("project.delete." + child.getNodeName()));
                Assert.assertTrue((boolean)permissionNames.contains("project.build." + child.getNodeName()));
            }
        });
    }

    protected void checkDependencies(PermissionNode permissionNode) {
        for (Permission permission : permissionNode.getPermissionList()) {
            List dependencies = permissionNode.getDependencies(permission);
            if (permission.getName().startsWith("project.read")) {
                Assert.assertEquals((long)dependencies.size(), (long)3L);
                continue;
            }
            Assert.assertNull((Object)dependencies);
        }
    }
}

