/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client.repositories;

import java.util.HashSet;
import java.util.Set;
import org.guvnor.common.services.project.client.repositories.ConflictingRepositoriesPopup;
import org.guvnor.common.services.project.client.repositories.ConflictingRepositoriesPopupView;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.shared.security.AppRoles;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class ConflictingRepositoriesPopupTest {
    @Mock
    ConflictingRepositoriesPopupView view;
    @Mock
    User user;
    private ConflictingRepositoriesPopup presenter;

    @Before
    public void setup() {
        this.presenter = new ConflictingRepositoriesPopup(this.user, this.view);
    }

    @Test
    public void testInitialization() {
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init(Mockito.eq((Object)this.presenter));
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addOKButton();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addOverrideButton((Command)Mockito.any(Command.class));
    }

    @Test
    public void testSetContent_Administrator() {
        GAV gav = (GAV)Mockito.mock(GAV.class);
        Command command = (Command)Mockito.mock(Command.class);
        HashSet metadata = new HashSet();
        HashSet<Role> roles = new HashSet<Role>(){
            {
                this.add(new RoleImpl(AppRoles.ADMIN.getName()));
            }
        };
        Mockito.when((Object)this.user.getRoles()).thenReturn((Object)roles);
        this.presenter.setContent(gav, metadata, command);
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setContent((GAV)Mockito.eq((Object)gav), (Set)Mockito.eq(metadata));
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addOKButton();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addOverrideButton((Command)Mockito.any(Command.class));
    }

    @Test
    public void testSetContent_NotAdministrator() {
        GAV gav = (GAV)Mockito.mock(GAV.class);
        Command command = (Command)Mockito.mock(Command.class);
        HashSet metadata = new HashSet();
        HashSet roles = new HashSet();
        Mockito.when((Object)this.user.getRoles()).thenReturn(roles);
        this.presenter.setContent(gav, metadata, command);
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setContent((GAV)Mockito.eq((Object)gav), (Set)Mockito.eq(metadata));
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addOKButton();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addOverrideButton((Command)Mockito.any(Command.class));
    }

    @Test
    public void testSetContent_Reuse() {
        GAV gav = (GAV)Mockito.mock(GAV.class);
        Command command = (Command)Mockito.mock(Command.class);
        HashSet metadata = new HashSet();
        HashSet<Role> roles = new HashSet<Role>(){
            {
                this.add(new RoleImpl(AppRoles.ADMIN.getName()));
            }
        };
        Mockito.when((Object)this.user.getRoles()).thenReturn((Object)roles);
        this.presenter.setContent(gav, metadata, command);
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setContent((GAV)Mockito.eq((Object)gav), (Set)Mockito.eq(metadata));
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addOKButton();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addOverrideButton((Command)Mockito.any(Command.class));
        this.presenter.setContent(gav, metadata, command);
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clear();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setContent((GAV)Mockito.eq((Object)gav), (Set)Mockito.eq(metadata));
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addOKButton();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addOverrideButton((Command)Mockito.any(Command.class));
    }

    @Test
    public void testShow() {
        this.presenter.show();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).show();
    }

    @Test
    public void testHide() {
        this.presenter.hide();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hide();
    }
}

