/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend.cmd;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.guvnor.rest.backend.JobRequestHelper;
import org.guvnor.rest.backend.JobResultManager;
import org.guvnor.rest.client.JobRequest;
import org.guvnor.rest.client.JobResult;
import org.guvnor.rest.client.JobStatus;
import org.jbpm.executor.cdi.CDIUtils;
import org.kie.api.executor.Command;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.runtime.process.WorkItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJobCommand
implements Command {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractJobCommand.class);
    public static final String JOB_REQUEST_KEY = "JobRequest";
    public static final String WORKITEM_KEY = "workItem";

    protected JobRequestHelper getHelper(CommandContext ctx) throws Exception {
        BeanManager beanManager = this.getBeanManager();
        return (JobRequestHelper)CDIUtils.createBean(JobRequestHelper.class, (BeanManager)beanManager, (Annotation[])new Annotation[0]);
    }

    protected JobRequest getJobRequest(CommandContext ctx) {
        JobRequest jobRequest = (JobRequest)ctx.getData(JOB_REQUEST_KEY);
        if (jobRequest != null) {
            return jobRequest;
        }
        WorkItem workItem = (WorkItem)ctx.getData(WORKITEM_KEY);
        if (workItem != null) {
            return (JobRequest)workItem.getParameter(JOB_REQUEST_KEY);
        }
        throw new RuntimeException("Unable to find JobRequest");
    }

    protected ExecutionResults getEmptyResult() {
        return new ExecutionResults();
    }

    private JobResultManager getJobManager(CommandContext ctx) throws Exception {
        BeanManager beanManager = this.getBeanManager();
        return (JobResultManager)CDIUtils.createBean(JobResultManager.class, (BeanManager)beanManager, (Annotation[])new Annotation[0]);
    }

    private BeanManager getBeanManager() {
        return BeanManagerProvider.getInstance().getBeanManager();
    }

    public ExecutionResults execute(CommandContext ctx) throws Exception {
        try {
            JobRequest request = this.getJobRequest(ctx);
            JobResult result = this.createResult(request);
            logger.debug("--- job {} ---, status: {}", (Object)result.getJobId(), (Object)result.getStatus());
            JobResultManager jobMgr = this.getJobManager(ctx);
            result.setLastModified(System.currentTimeMillis());
            jobMgr.putJob(result);
            if (JobStatus.APPROVED.equals((Object)request.getStatus())) {
                try {
                    result = this.internalExecute(ctx, request);
                }
                catch (Exception e) {
                    result.setStatus(JobStatus.SERVER_ERROR);
                    result.setResult("Request failed because of " + e.getClass().getSimpleName() + ": " + e.getMessage());
                    logger.error("{} [{}] failed because of thrown {}: {}", new Object[]{request.getClass().getSimpleName(), request.getJobId(), e.getClass().getSimpleName(), e.getMessage(), e});
                }
                logger.debug("--- job {} ---, status: {}", (Object)result.getJobId(), (Object)result.getStatus());
                result.setLastModified(System.currentTimeMillis());
                jobMgr.putJob(result);
            }
            return this.getEmptyResult();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private JobResult createResult(JobRequest jobRequest) {
        JobResult jobResult = new JobResult();
        jobResult.setJobId(jobRequest.getJobId());
        jobResult.setStatus(jobRequest.getStatus());
        return jobResult;
    }

    protected abstract JobResult internalExecute(CommandContext var1, JobRequest var2) throws Exception;
}

