/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.rest.client.JobRequest;
import org.guvnor.rest.client.JobResult;
import org.guvnor.rest.client.JobStatus;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.RequestInfo;
import org.kie.api.runtime.query.QueryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JobResultManager {
    private static final Logger logger = LoggerFactory.getLogger(JobResultManager.class);
    private static AtomicInteger created = new AtomicInteger(0);
    private Map<String, JobResult> jobs = null;
    private int maxCacheSize = 10000;
    @Inject
    private Instance<ExecutorService> jobExecutor;

    @PostConstruct
    public void start() {
        if (!created.compareAndSet(0, 1)) {
            throw new IllegalStateException("Only 1 JobResultManager instance is allowed per container!");
        }
        Cache cache = new Cache(this.maxCacheSize);
        this.jobs = Collections.synchronizedMap(cache);
    }

    public JobResult getJob(String jobId) {
        List jobsFound;
        JobResult job = this.jobs.get(jobId);
        if (job != null && !JobStatus.ACCEPTED.equals((Object)job.getStatus())) {
            return job;
        }
        if (!this.jobExecutor.isUnsatisfied() && (jobsFound = ((ExecutorService)this.jobExecutor.get()).getRequestsByBusinessKey(jobId, new QueryContext())) != null && !jobsFound.isEmpty()) {
            JobRequest jobRequest;
            RequestInfo executorJob = (RequestInfo)jobsFound.get(0);
            JobResult requestedJob = (JobResult)this.getItemFromRequestOutput("JobResult", executorJob);
            if (requestedJob == null && (jobRequest = (JobRequest)this.getItemFromRequestInput("JobRequest", executorJob)) != null) {
                requestedJob = new JobResult();
                requestedJob.setJobId(jobRequest.getJobId());
                requestedJob.setStatus(jobRequest.getStatus());
            }
            if (requestedJob != null) {
                job = requestedJob;
                this.jobs.put(jobId, job);
            }
        }
        return job;
    }

    public void putJob(JobResult job) {
        this.jobs.put(job.getJobId(), job);
    }

    public JobResult removeJob(String jobId) {
        return this.jobs.remove(jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getItemFromRequestInput(String itemName, RequestInfo requestInfo) {
        CommandContext ctx = null;
        byte[] requestData = requestInfo.getRequestData();
        if (requestData != null) {
            ObjectInputStream in = null;
            try {
                in = new ObjectInputStream(new ByteArrayInputStream(requestData));
                ctx = (CommandContext)in.readObject();
            }
            catch (Exception e) {
                logger.debug("Exception while deserializing context data of job with id {}", (Object)requestInfo.getId(), (Object)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (ctx != null && ctx.getData(itemName) != null) {
            return ctx.getData(itemName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getItemFromRequestOutput(String itemName, RequestInfo requestInfo) {
        ExecutionResults execResults = null;
        byte[] responseData = requestInfo.getResponseData();
        if (responseData != null) {
            ObjectInputStream in = null;
            try {
                in = new ObjectInputStream(new ByteArrayInputStream(responseData));
                execResults = (ExecutionResults)in.readObject();
            }
            catch (Exception e) {
                logger.debug("Exception while deserializing context data of job with id {}", (Object)requestInfo.getId(), (Object)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (execResults != null && execResults.getData(itemName) != null) {
            return execResults.getData(itemName);
        }
        return null;
    }

    private static class Cache
    extends LinkedHashMap<String, JobResult> {
        private int maxSize = 1000;

        public Cache(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, JobResult> stringFutureEntry) {
            return this.size() > this.maxSize;
        }

        public void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
        }
    }
}

