/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.rest.backend.JobRequestHelper;
import org.guvnor.rest.backend.JobResultManager;
import org.guvnor.rest.backend.cmd.AbstractJobCommand;
import org.guvnor.rest.backend.cmd.AddRepositoryToOrgUnitCmd;
import org.guvnor.rest.backend.cmd.CompileProjectCmd;
import org.guvnor.rest.backend.cmd.CreateOrCloneRepositoryCmd;
import org.guvnor.rest.backend.cmd.CreateOrgUnitCmd;
import org.guvnor.rest.backend.cmd.CreateProjectCmd;
import org.guvnor.rest.backend.cmd.DeleteProjectCmd;
import org.guvnor.rest.backend.cmd.DeployProjectCmd;
import org.guvnor.rest.backend.cmd.InstallProjectCmd;
import org.guvnor.rest.backend.cmd.RemoveOrgUnitCmd;
import org.guvnor.rest.backend.cmd.RemoveRepositoryCmd;
import org.guvnor.rest.backend.cmd.RemoveRepositoryFromOrgUnitCmd;
import org.guvnor.rest.backend.cmd.TestProjectCmd;
import org.guvnor.rest.backend.cmd.UpdateOrgUnitCmd;
import org.guvnor.rest.client.AddRepositoryToOrganizationalUnitRequest;
import org.guvnor.rest.client.CompileProjectRequest;
import org.guvnor.rest.client.CreateOrCloneRepositoryRequest;
import org.guvnor.rest.client.CreateOrganizationalUnitRequest;
import org.guvnor.rest.client.CreateProjectRequest;
import org.guvnor.rest.client.DeleteProjectRequest;
import org.guvnor.rest.client.DeployProjectRequest;
import org.guvnor.rest.client.InstallProjectRequest;
import org.guvnor.rest.client.JobRequest;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.rest.client.RemoveOrganizationalUnitRequest;
import org.guvnor.rest.client.RemoveRepositoryFromOrganizationalUnitRequest;
import org.guvnor.rest.client.RemoveRepositoryRequest;
import org.guvnor.rest.client.TestProjectRequest;
import org.guvnor.rest.client.UpdateOrganizationalUnitRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.async.SimpleAsyncExecutorService;

@ApplicationScoped
public class JobRequestScheduler {
    private static final Logger logger = LoggerFactory.getLogger(JobRequestScheduler.class);
    @Inject
    private JobResultManager jobResultManager;
    @Inject
    private JobRequestHelper jobRequestHelper;

    public void createOrCloneRepositoryRequest(CreateOrCloneRepositoryRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Repository", jobRequest.getRepository().getName());
        params.put("Operation", "createOrCloneRepository");
        this.scheduleJob((JobRequest)jobRequest, new CreateOrCloneRepositoryCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void removeRepositoryRequest(RemoveRepositoryRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Repository", jobRequest.getRepositoryName());
        params.put("Operation", "removeRepository");
        this.scheduleJob((JobRequest)jobRequest, new RemoveRepositoryCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void createProjectRequest(CreateProjectRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Repository", jobRequest.getRepositoryName());
        params.put("Project", jobRequest.getProjectName());
        params.put("Operation", "createProject");
        this.scheduleJob((JobRequest)jobRequest, new CreateProjectCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void deleteProjectRequest(DeleteProjectRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Repository", jobRequest.getRepositoryName());
        params.put("Project", jobRequest.getProjectName());
        params.put("Operation", "deleteProject");
        this.scheduleJob((JobRequest)jobRequest, new DeleteProjectCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void compileProjectRequest(CompileProjectRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Repository", jobRequest.getRepositoryName());
        params.put("Project", jobRequest.getProjectName());
        params.put("Operation", "compileProject");
        this.scheduleJob((JobRequest)jobRequest, new CompileProjectCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void installProjectRequest(InstallProjectRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Repository", jobRequest.getRepositoryName());
        params.put("Project", jobRequest.getProjectName());
        params.put("Operation", "installProject");
        this.scheduleJob((JobRequest)jobRequest, new InstallProjectCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void testProjectRequest(TestProjectRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Repository", jobRequest.getRepositoryName());
        params.put("Project", jobRequest.getProjectName());
        params.put("Operation", "testProject");
        this.scheduleJob((JobRequest)jobRequest, new TestProjectCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void deployProjectRequest(DeployProjectRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Repository", jobRequest.getRepositoryName());
        params.put("Project", jobRequest.getProjectName());
        params.put("Operation", "deployProject");
        this.scheduleJob((JobRequest)jobRequest, new DeployProjectCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void createOrganizationalUnitRequest(CreateOrganizationalUnitRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Operation", "createOrgUnit");
        this.scheduleJob((JobRequest)jobRequest, new CreateOrgUnitCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void updateOrganizationalUnitRequest(UpdateOrganizationalUnitRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Operation", "updateOrgUnit");
        this.scheduleJob((JobRequest)jobRequest, new UpdateOrgUnitCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void addRepositoryToOrganizationalUnitRequest(AddRepositoryToOrganizationalUnitRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Repository", jobRequest.getRepositoryName());
        params.put("Operation", "addRepositoryToOrgUnit");
        this.scheduleJob((JobRequest)jobRequest, new AddRepositoryToOrgUnitCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void removeRepositoryFromOrganizationalUnitRequest(RemoveRepositoryFromOrganizationalUnitRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Repository", jobRequest.getRepositoryName());
        params.put("Operation", "removeRepositoryFromOrgUnit");
        this.scheduleJob((JobRequest)jobRequest, new RemoveRepositoryFromOrgUnitCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void removeOrganizationalUnitRequest(RemoveOrganizationalUnitRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Operation", "removeOrgUnit");
        this.scheduleJob((JobRequest)jobRequest, new RemoveOrgUnitCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    protected Map<String, Object> getContext(JobRequest jobRequest) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("JobRequest", jobRequest);
        params.put("BusinessKey", jobRequest.getJobId());
        params.put("Retries", 0);
        return params;
    }

    private void scheduleJob(JobRequest jobRequest, AbstractJobCommand command) {
        jobRequest.setStatus(JobStatus.APPROVED);
        logger.debug("Scheduling job request with id: {} and command class: {}", (Object)jobRequest.getJobId(), (Object)command.getClass().getName());
        SimpleAsyncExecutorService.getDefaultInstance().execute((Runnable)((Object)command));
    }
}

