/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.config.ConfigGroup;
import org.uberfire.backend.server.config.ConfigItem;
import org.uberfire.backend.server.config.ConfigType;
import org.uberfire.backend.server.config.ConfigurationService;

public class ApplicationPreferencesLoader {
    @Inject
    private ConfigurationService configurationService;
    private static final Logger log = LoggerFactory.getLogger(ApplicationPreferencesLoader.class);

    public Map<String, String> load() {
        Map<String, String> preferences = this.getSystemProperties();
        List configs = this.configurationService.getConfiguration(ConfigType.GLOBAL);
        for (ConfigGroup config : configs) {
            for (ConfigItem item : config.getItems()) {
                String name = item.getName();
                String value = config.getConfigItemValue(name);
                log.info("Setting preference '" + name + "' to '" + value + "'.");
                preferences.put(name, value);
            }
        }
        return preferences;
    }

    private Map<String, String> getSystemProperties() {
        HashMap<String, String> preferences = new HashMap<String, String>();
        this.addSystemProperty(preferences, "drools.dateformat");
        this.addSystemProperty(preferences, "drools.datetimeformat");
        this.addSystemProperty(preferences, "drools.defaultlanguage");
        this.addSystemProperty(preferences, "drools.defaultcountry");
        return preferences;
    }

    private void addSystemProperty(Map<String, String> preferences, String key) {
        String value = System.getProperty(key);
        if (value != null) {
            log.info("Setting preference '" + key + "' to '" + value + "'.");
            preferences.put(key, value);
        }
    }
}

