/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.metadata;

import com.thoughtworks.xstream.XStream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.shared.metadata.CategoriesService;
import org.guvnor.common.services.shared.metadata.model.Categories;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.uberfire.backend.server.util.Paths;

@Service
@ApplicationScoped
public class CategoryServiceImpl
implements CategoriesService {
    private final XStream xt = new XStream();
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private Paths paths;

    public void save(org.uberfire.backend.vfs.Path path, Categories content) {
        try {
            this.ioService.write(this.paths.convert(path), this.xt.toXML((Object)content), new OpenOption[0]);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public Categories getContent(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(this.paths.convert(path));
            Categories categories = content.trim().equals("") ? new Categories() : (Categories)this.xt.fromXML(content);
            return categories;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public Categories getCategoriesFromResource(org.uberfire.backend.vfs.Path resource) {
        try {
            Path categoriesPath = this.paths.convert(resource).getRoot().resolve("categories.xml");
            return this.getContent(this.paths.convert(categoriesPath));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }
}

