/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.file;

import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.shared.file.DeleteService;
import org.jboss.errai.bus.server.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Identity;

@Service
public class DeleteServiceImpl
implements DeleteService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteServiceImpl.class);
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private Identity identity;
    @Inject
    private SessionInfo sessionInfo;

    public void delete(Path path, String comment) {
        try {
            LOGGER.info("User:" + this.identity.getName() + " deleting file [" + path.getFileName() + "]");
            this.ioService.delete(Paths.convert((Path)path), new DeleteOption[]{new CommentedOption(this.sessionInfo.getId(), this.identity.getName(), null, comment)});
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }
}

