/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.rulenames;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.events.RuleNameUpdateEvent;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.rulenames.RuleNamesService;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.vfs.Path;

@Service
@ApplicationScoped
public class RuleNamesServiceImpl
implements RuleNamesService {
    private ProjectService projectService;
    private final Map<Project, Map<String, Collection<String>>> ruleNames = new HashMap<Project, Map<String, Collection<String>>>();

    public RuleNamesServiceImpl() {
    }

    @Inject
    public RuleNamesServiceImpl(ProjectService projectService) {
        this.projectService = projectService;
    }

    public Map<String, Collection<String>> getRuleNamesMap(Path path) {
        Project project = this.projectService.resolveProject(path);
        if (project == null) {
            return Collections.emptyMap();
        }
        return this.ruleNames.get(project);
    }

    public List<String> getRuleNames(Path path) {
        Project project = this.projectService.resolveProject(path);
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<String> allTheRuleNames = new ArrayList<String>();
        for (String packageName : this.ruleNames.get(project).keySet()) {
            allTheRuleNames.addAll(this.ruleNames.get(project).get(packageName));
        }
        return allTheRuleNames;
    }

    public Collection<String> getRuleNamesForPackage(Path path, String packageName) {
        Project project = this.projectService.resolveProject(path);
        if (project == null) {
            return Collections.emptyList();
        }
        if (!this.ruleNames.get(project).containsKey(packageName)) {
            return Collections.emptyList();
        }
        return this.ruleNames.get(project).get(packageName);
    }

    void onRuleNamesUpdated(@Observes RuleNameUpdateEvent ruleNameUpdateEvent) {
        this.ruleNames.put(ruleNameUpdateEvent.getProject(), new HashMap(ruleNameUpdateEvent.getRuleNames()));
    }
}

