/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.validation;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.file.DotFileFilter;
import org.guvnor.common.services.backend.file.KModuleFileFilter;
import org.guvnor.common.services.backend.file.PomFileFilter;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class DefaultGenericKieValidator
implements GenericValidator {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private ProjectService projectService;
    private final DirectoryStream.Filter<Path> dotFileFilter = new DotFileFilter();
    private final DirectoryStream.Filter<Path> kmoduleFileFilter = new KModuleFileFilter();
    private final DirectoryStream.Filter<Path> pomFileFilter = new PomFileFilter();

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path resourcePath, InputStream resource, DirectoryStream.Filter<Path> ... supportingFileFilters) {
        Project project = this.projectService.resolveProject(resourcePath);
        if (project == null) {
            return Collections.emptyList();
        }
        KieServices kieServices = KieServices.Factory.get();
        KieFileSystem kieFileSystem = kieServices.newKieFileSystem();
        String projectPrefix = project.getRootPath().toURI();
        Path nioProjectRoot = Paths.convert((org.uberfire.backend.vfs.Path)project.getRootPath());
        DirectoryStream directoryStream = Files.newDirectoryStream((Path)nioProjectRoot);
        this.visitPaths(projectPrefix, kieFileSystem, (DirectoryStream<Path>)directoryStream, supportingFileFilters);
        String destinationPath = resourcePath.toURI().substring(projectPrefix.length() + 1);
        BufferedInputStream bis = new BufferedInputStream(resource);
        kieFileSystem.write(destinationPath, KieServices.Factory.get().getResources().newInputStreamResource((InputStream)bis));
        KieBuilder kieBuilder = kieServices.newKieBuilder(kieFileSystem);
        Results kieResults = kieBuilder.buildAll().getResults();
        List<ValidationMessage> results = this.convertMessages(kieResults);
        return results;
    }

    private void visitPaths(String projectPrefix, KieFileSystem kieFileSystem, DirectoryStream<Path> directoryStream, DirectoryStream.Filter<Path> ... supportingFileFilters) {
        for (Path path : directoryStream) {
            if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) {
                this.visitPaths(projectPrefix, kieFileSystem, (DirectoryStream<Path>)Files.newDirectoryStream((Path)path), supportingFileFilters);
                continue;
            }
            if (!this.acceptPath(path, supportingFileFilters)) continue;
            String destinationPath = path.toUri().toString().substring(projectPrefix.length() + 1);
            InputStream is = this.ioService.newInputStream(path, new OpenOption[0]);
            BufferedInputStream bis = new BufferedInputStream(is);
            kieFileSystem.write(destinationPath, KieServices.Factory.get().getResources().newInputStreamResource((InputStream)bis));
        }
    }

    private boolean acceptPath(Path path, DirectoryStream.Filter<Path> ... supportingFileFilters) {
        if (this.dotFileFilter.accept((Object)path)) {
            return false;
        }
        if (this.kmoduleFileFilter.accept((Object)path)) {
            return false;
        }
        if (this.pomFileFilter.accept((Object)path)) {
            return true;
        }
        for (DirectoryStream.Filter<Path> filter : supportingFileFilters) {
            if (!filter.accept((Object)path)) continue;
            return true;
        }
        return false;
    }

    private List<ValidationMessage> convertMessages(Results kieBuildResults) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        for (Message message : kieBuildResults.getMessages()) {
            validationMessages.add(this.convertMessage(message));
        }
        return validationMessages;
    }

    private ValidationMessage convertMessage(Message message) {
        ValidationMessage msg = new ValidationMessage();
        switch (message.getLevel()) {
            case ERROR: {
                msg.setLevel(ValidationMessage.Level.ERROR);
                break;
            }
            case WARNING: {
                msg.setLevel(ValidationMessage.Level.WARNING);
                break;
            }
            case INFO: {
                msg.setLevel(ValidationMessage.Level.INFO);
            }
        }
        msg.setId(message.getId());
        msg.setLine(message.getLine());
        msg.setColumn(message.getColumn());
        msg.setText(message.getText());
        return msg;
    }
}

