/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.file.upload;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.guvnor.common.services.backend.file.upload.FormData;
import org.guvnor.common.services.shared.file.upload.FileOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.Path;

public abstract class AbstractFileServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(AbstractFileServlet.class);
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
    private static final long serialVersionUID = 510L;

    protected abstract InputStream doLoad(Path var1, HttpServletRequest var2);

    protected abstract void doCreate(Path var1, InputStream var2, HttpServletRequest var3, String var4);

    protected abstract void doUpdate(Path var1, InputStream var2, HttpServletRequest var3, String var4);

    protected abstract Path convertPath(String var1, String var2) throws URISyntaxException;

    protected abstract Path convertPath(String var1) throws URISyntaxException;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        FormData item = this.getFormData(request);
        if (item.getFile() != null) {
            response.getWriter().write(this.processUpload(item, request));
            return;
        }
        response.getWriter().write("NO-SCRIPT-DATA");
    }

    private FormData getFormData(HttpServletRequest request) throws IOException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setHeaderEncoding("UTF-8");
        request.setCharacterEncoding("UTF-8");
        FormData data = new FormData();
        try {
            List items = upload.parseRequest(request);
            Iterator it = items.iterator();
            FileOperation operation = null;
            String fileName = null;
            String contextPath = null;
            String fullPath = null;
            while (it.hasNext()) {
                FileItem item = (FileItem)it.next();
                if (!item.isFormField()) {
                    data.setFile(item);
                    continue;
                }
                if (item.getFieldName().equals("attachmentPath")) {
                    contextPath = item.getString("UTF-8");
                    log.debug("path:" + contextPath);
                    continue;
                }
                if (item.getFieldName().equals("fileName")) {
                    fileName = item.getString("UTF-8");
                    log.debug("name:" + fileName);
                    continue;
                }
                if (item.getFieldName().equals("attachmentFullPath")) {
                    fullPath = item.getString("UTF-8");
                    log.debug("full path:" + fullPath);
                    continue;
                }
                if (!item.getFieldName().equals("operation")) continue;
                operation = FileOperation.valueOf((String)item.getString("UTF-8"));
                log.debug("operation:" + operation);
            }
            if (operation == null) {
                throw new IllegalArgumentException("FORM_FIELD_OPERATION is null. Cannot process upload.");
            }
            switch (operation) {
                case CREATE: {
                    if (fileName == null) {
                        throw new IllegalArgumentException("FORM_FIELD_NAME is null. Cannot process upload.");
                    }
                    if (contextPath == null) {
                        throw new IllegalArgumentException("FORM_FIELD_PATH is null. Cannot process upload.");
                    }
                    data.setOperation(operation);
                    data.setTargetPath(this.convertPath(fileName, contextPath));
                    break;
                }
                case UPDATE: {
                    if (fullPath == null) {
                        throw new IllegalArgumentException("FORM_FIELD_FULL_PATH is null. Cannot process upload.");
                    }
                    data.setOperation(operation);
                    data.setTargetPath(this.convertPath(fullPath));
                }
            }
            return data;
        }
        catch (Exception e) {
            throw new org.uberfire.java.nio.IOException(e.getMessage());
        }
    }

    private String processUpload(FormData item, HttpServletRequest request) throws IOException {
        if ("".equals(item.getFile().getName())) {
            throw new IOException("No file selected.");
        }
        String processResult = this.uploadFile(item, request);
        return processResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String uploadFile(FormData item, HttpServletRequest request) throws IOException {
        InputStream fileData = item.getFile().getInputStream();
        Path targetPath = item.getTargetPath();
        try {
            switch (item.getOperation()) {
                case CREATE: {
                    this.doCreate(targetPath, fileData, request, "Uploaded " + this.getTimestamp());
                    return "OK";
                }
                case UPDATE: {
                    this.doUpdate(targetPath, fileData, request, "Uploaded " + this.getTimestamp());
                    return "OK";
                }
            }
            return "OK";
        }
        finally {
            item.getFile().getInputStream().close();
        }
    }

    private String getTimestamp() {
        Calendar now = Calendar.getInstance();
        StringBuilder sb = new StringBuilder();
        sb.append(sdf.format(now.getTime()));
        return sb.toString();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getParameter("attachmentPath");
        if (path != null) {
            this.processAttachmentDownload(path, request, response);
        } else {
            response.sendError(400);
        }
    }

    protected void processAttachmentDownload(String url, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            Path sourcePath = this.convertPath(url);
            IOUtils.copy((InputStream)this.doLoad(sourcePath, request), (OutputStream)output);
            String fileName = url.substring(url.lastIndexOf("/") + 1);
            response.setContentType("application/x-download");
            response.setHeader("Content-Disposition", "attachment; filename*=utf-8''" + fileName);
            response.setContentLength(output.size());
            response.getOutputStream().write(output.toByteArray());
            response.getOutputStream().flush();
        }
        catch (Exception e) {
            throw new org.uberfire.java.nio.IOException(e.getMessage());
        }
    }
}

