/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.version;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.guvnor.common.services.backend.version.PathResolverImpl;
import org.guvnor.common.services.backend.version.VersionLoader;
import org.guvnor.common.services.backend.version.VersionUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.Path;

public class PathResolverImplTest {
    private VersionLoader versionLoader;
    private PathResolverImpl resolver;
    private HashMap<Path, List<VersionRecord>> versionRecords;
    private Path pathToMainFile;
    private Path pathToDotFile;
    private IOService ioService;
    private VersionUtil versionUtil;

    @Before
    public void setUp() throws Exception {
        this.ioService = (IOService)Mockito.mock(IOService.class);
        this.versionUtil = (VersionUtil)Mockito.mock(VersionUtil.class);
        this.versionLoader = new VersionLoaderMock(this.ioService, this.versionUtil);
        Mockito.when((Object)this.versionUtil.getPath((Path)Mockito.any(Path.class), (String)Mockito.eq((Object)"master"))).thenReturn((Object)this.pathToMainFile);
        this.pathToMainFile = this.makePath("text.txt");
        this.pathToDotFile = this.makePath(".text.txt");
        this.resolver = new PathResolverImpl(this.versionLoader, new VersionUtil(){

            Path getPath(Path path, String version) throws URISyntaxException {
                return super.getPath(path, version);
            }
        });
        this.versionRecords = new HashMap();
        ArrayList<VersionRecord> mainHistory = new ArrayList<VersionRecord>();
        mainHistory.add(this.makeVersionRecord("id1", new Date(1L)));
        mainHistory.add(this.makeVersionRecord("id3", new Date(3L)));
        mainHistory.add(this.makeVersionRecord("id4", new Date(4L)));
        ArrayList<VersionRecord> dotFileHistory = new ArrayList<VersionRecord>();
        dotFileHistory.add(this.makeVersionRecord("id1", new Date(1L)));
        dotFileHistory.add(this.makeVersionRecord("id2", new Date(2L)));
        dotFileHistory.add(this.makeVersionRecord("id5", new Date(5L)));
        this.versionRecords.put(this.pathToMainFile, mainHistory);
        this.versionRecords.put(this.pathToDotFile, dotFileHistory);
    }

    @Test
    public void testResolveFromMainFile() throws Exception {
        Assert.assertEquals((Object)"text.txt", (Object)this.resolver.resolveMainFilePath(this.pathToMainFile).getFileName().toString());
    }

    @Test
    public void testResolveFromDotFile() throws Exception {
        Assert.assertEquals((Object)"text.txt", (Object)this.resolver.resolveMainFilePath(this.pathToDotFile).getFileName().toString());
    }

    private Path makePath(String fileName) {
        Path path = (Path)Mockito.mock(Path.class);
        Path fileNamePath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)fileNamePath);
        Mockito.when((Object)fileNamePath.toString()).thenReturn((Object)fileName);
        Mockito.when((Object)path.resolveSibling(Mockito.anyString())).thenAnswer((Answer)new Answer<Path>(){

            public Path answer(InvocationOnMock invocationOnMock) throws Throwable {
                return PathResolverImplTest.this.makePath((String)invocationOnMock.getArguments()[0]);
            }
        });
        return path;
    }

    private VersionRecord makeVersionRecord(final String id, final Date date) {
        return new VersionRecord(){

            public String id() {
                return id;
            }

            public String author() {
                return null;
            }

            public String email() {
                return null;
            }

            public String comment() {
                return null;
            }

            public Date date() {
                return date;
            }

            public String uri() {
                return null;
            }
        };
    }

    private class VersionLoaderMock
    extends VersionLoader {
        public VersionLoaderMock(IOService ioService, VersionUtil versionUtil) {
            super(ioService, versionUtil);
        }

        public List<VersionRecord> load(Path path) {
            return (List)PathResolverImplTest.this.versionRecords.get(path);
        }
    }
}

