/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.version;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.guvnor.common.services.backend.MockIOService;
import org.guvnor.common.services.backend.version.VersionLoader;
import org.guvnor.common.services.backend.version.VersionUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.base.version.VersionAttributes;
import org.uberfire.java.nio.base.version.VersionHistory;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttributeView;
import org.uberfire.java.nio.file.attribute.FileTime;

public class VersionLoaderTest {
    private MockIOService ioService;
    private Path pathToFile;
    private Path pathToDotFile;
    private ArrayList<VersionRecord> dotFileVersionRecords = new ArrayList();
    private ArrayList<VersionRecord> mainFileVersionRecords = new ArrayList();

    @Before
    public void setUp() throws Exception {
        this.pathToFile = (Path)Mockito.mock(Path.class);
        this.pathToDotFile = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)this.pathToFile.resolveSibling(Mockito.anyString())).thenReturn((Object)this.pathToDotFile);
        this.ioService = new MockIOService(){

            public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> vClass) throws IllegalArgumentException {
                return (V)((Object)new MockVersionAttributeView(path));
            }
        };
        this.mainFileVersionRecords.add(this.makeVersionRecord("id1", new Date(1L)));
        this.mainFileVersionRecords.add(this.makeVersionRecord("id3", new Date(3L)));
        this.mainFileVersionRecords.add(this.makeVersionRecord("id4", new Date(4L)));
        this.dotFileVersionRecords.add(this.makeVersionRecord("id1", new Date(1L)));
        this.dotFileVersionRecords.add(this.makeVersionRecord("id2", new Date(2L)));
        this.dotFileVersionRecords.add(this.makeVersionRecord("id5", new Date(5L)));
    }

    @Test
    public void testSimple() throws Exception {
        this.ioService.setExistingPaths(new Path[]{this.pathToFile, this.pathToDotFile});
        VersionLoader versionLoader = new VersionLoader((IOService)this.ioService, new VersionUtil());
        List versions = versionLoader.load(this.pathToFile);
        Assert.assertEquals((long)5L, (long)versions.size());
        Assert.assertEquals((Object)"id1", (Object)((VersionRecord)versions.get(0)).id());
        Assert.assertEquals((Object)"id2", (Object)((VersionRecord)versions.get(1)).id());
        Assert.assertEquals((Object)"id3", (Object)((VersionRecord)versions.get(2)).id());
        Assert.assertEquals((Object)"id4", (Object)((VersionRecord)versions.get(3)).id());
        Assert.assertEquals((Object)"id5", (Object)((VersionRecord)versions.get(4)).id());
    }

    @Test
    public void testNoDotFile() throws Exception {
        this.ioService.setExistingPaths(new Path[]{this.pathToFile});
        VersionLoader versionLoader = new VersionLoader((IOService)this.ioService, new VersionUtil());
        List versions = versionLoader.load(this.pathToFile);
        Assert.assertEquals((long)3L, (long)versions.size());
        Assert.assertEquals((Object)"id1", (Object)((VersionRecord)versions.get(0)).id());
        Assert.assertEquals((Object)"id3", (Object)((VersionRecord)versions.get(1)).id());
        Assert.assertEquals((Object)"id4", (Object)((VersionRecord)versions.get(2)).id());
    }

    @Test
    public void testLoadRecord() throws Exception {
        this.ioService.setExistingPaths(new Path[]{this.pathToFile});
        VersionLoader versionLoader = new VersionLoader((IOService)this.ioService, new VersionUtil(){

            Path getPath(Path path, String version) throws URISyntaxException {
                return path;
            }

            String getVersion(Path path) {
                return "id3";
            }
        });
        VersionRecord record = versionLoader.loadRecord(this.pathToFile);
        Assert.assertEquals((Object)record.id(), (Object)"id3");
    }

    @Test
    public void testLoadRecordMaster() throws Exception {
        this.ioService.setExistingPaths(new Path[]{this.pathToFile});
        VersionLoader versionLoader = new VersionLoader((IOService)this.ioService, new VersionUtil(){

            Path getPath(Path path, String version) throws URISyntaxException {
                return path;
            }

            String getVersion(Path path) {
                return "master";
            }
        });
        VersionRecord record = versionLoader.loadRecord(this.pathToFile);
        Assert.assertEquals((Object)record.id(), (Object)"id1");
    }

    private VersionRecord makeVersionRecord(final String id, final Date date) {
        return new VersionRecord(){

            public String id() {
                return id;
            }

            public String author() {
                return null;
            }

            public String email() {
                return null;
            }

            public String comment() {
                return null;
            }

            public Date date() {
                return date;
            }

            public String uri() {
                return null;
            }
        };
    }

    private class MockVersionAttributeView
    extends VersionAttributeView<Path> {
        List<VersionRecord> records;

        public MockVersionAttributeView(Path path) {
            super(path);
            this.records = VersionLoaderTest.this.pathToFile.equals(path) ? VersionLoaderTest.this.mainFileVersionRecords : VersionLoaderTest.this.dotFileVersionRecords;
        }

        public VersionAttributes readAttributes() throws IOException {
            return new VersionAttributes(){

                public VersionHistory history() {
                    return new VersionHistory(){

                        public List<VersionRecord> records() {
                            return MockVersionAttributeView.this.records;
                        }
                    };
                }

                public FileTime lastModifiedTime() {
                    return null;
                }

                public FileTime lastAccessTime() {
                    return null;
                }

                public FileTime creationTime() {
                    return null;
                }

                public boolean isRegularFile() {
                    return false;
                }

                public boolean isDirectory() {
                    return false;
                }

                public boolean isSymbolicLink() {
                    return false;
                }

                public boolean isOther() {
                    return false;
                }

                public long size() {
                    return 0L;
                }

                public Object fileKey() {
                    return null;
                }
            };
        }

        public Class[] viewTypes() {
            return new Class[0];
        }
    }
}

