/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.metadata.MetadataBuilder;
import org.guvnor.common.services.backend.metadata.MetadataServerSideService;
import org.guvnor.common.services.backend.metadata.attribute.DiscussionAttributes;
import org.guvnor.common.services.backend.metadata.attribute.DiscussionAttributesUtil;
import org.guvnor.common.services.backend.metadata.attribute.DiscussionView;
import org.guvnor.common.services.backend.metadata.attribute.OtherMetaAttributes;
import org.guvnor.common.services.backend.metadata.attribute.OtherMetaAttributesUtil;
import org.guvnor.common.services.backend.metadata.attribute.OtherMetaView;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.DiscussionRecord;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.editor.commons.version.impl.PortableVersionRecord;
import org.uberfire.io.IOService;
import org.uberfire.io.attribute.DublinCoreAttributes;
import org.uberfire.io.attribute.DublinCoreAttributesUtil;
import org.uberfire.io.attribute.DublinCoreView;
import org.uberfire.java.nio.base.BasicFileAttributesUtil;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileTime;

@Service
@ApplicationScoped
public class MetadataServiceImpl
implements MetadataService,
MetadataServerSideService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;

    public Metadata getMetadata(org.uberfire.backend.vfs.Path pathToResource) {
        return this.getMetadata(Paths.convert((org.uberfire.backend.vfs.Path)pathToResource));
    }

    public Metadata getMetadataDirectPath(Path path) {
        OtherMetaView fileAttributeView = (OtherMetaView)Files.getFileAttributeView((Path)path, OtherMetaView.class, (LinkOption[])new LinkOption[0]);
        return new Metadata();
    }

    public Metadata getMetadata(Path path) {
        try {
            DublinCoreView dcoreView = (DublinCoreView)this.ioService.getFileAttributeView(path, DublinCoreView.class);
            DiscussionView discussView = (DiscussionView)this.ioService.getFileAttributeView(path, DiscussionView.class);
            OtherMetaView otherMetaView = (OtherMetaView)this.ioService.getFileAttributeView(path, OtherMetaView.class);
            final VersionAttributeView versionAttributeView = (VersionAttributeView)this.ioService.getFileAttributeView(path, VersionAttributeView.class);
            return MetadataBuilder.newMetadata().withPath(Paths.convert((Path)path.toRealPath(new LinkOption[0]))).withCheckinComment(versionAttributeView.readAttributes().history().records().size() > 0 ? ((VersionRecord)versionAttributeView.readAttributes().history().records().get(versionAttributeView.readAttributes().history().records().size() - 1)).comment() : null).withLastContributor(versionAttributeView.readAttributes().history().records().size() > 0 ? ((VersionRecord)versionAttributeView.readAttributes().history().records().get(versionAttributeView.readAttributes().history().records().size() - 1)).author() : null).withCreator(versionAttributeView.readAttributes().history().records().size() > 0 ? ((VersionRecord)versionAttributeView.readAttributes().history().records().get(0)).author() : null).withLastModified(new Date(versionAttributeView.readAttributes().lastModifiedTime().toMillis())).withDateCreated(new Date(versionAttributeView.readAttributes().creationTime().toMillis())).withSubject(dcoreView.readAttributes().subjects().size() > 0 ? (String)dcoreView.readAttributes().subjects().get(0) : null).withType(dcoreView.readAttributes().types().size() > 0 ? (String)dcoreView.readAttributes().types().get(0) : null).withExternalRelation(dcoreView.readAttributes().relations().size() > 0 ? (String)dcoreView.readAttributes().relations().get(0) : null).withExternalSource(dcoreView.readAttributes().sources().size() > 0 ? (String)dcoreView.readAttributes().sources().get(0) : null).withDescription(dcoreView.readAttributes().descriptions().size() > 0 ? (String)dcoreView.readAttributes().descriptions().get(0) : null).withCategories(otherMetaView.readAttributes().categories()).withDiscussion(discussView.readAttributes().discussion()).withVersion((List<VersionRecord>)new ArrayList<VersionRecord>(versionAttributeView.readAttributes().history().records().size()){
                {
                    super(x0);
                    for (VersionRecord record : versionAttributeView.readAttributes().history().records()) {
                        this.add(new PortableVersionRecord(record.id(), record.author(), record.email(), record.comment(), record.date(), record.uri()));
                    }
                }
            }).build();
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public Map<String, Object> configAttrs(Map<String, Object> _attrs, final Metadata metadata) {
        try {
            PortablePreconditions.checkNotNull((String)"_attrs", _attrs);
            PortablePreconditions.checkNotNull((String)"metadata", (Object)metadata);
            Map<String, Object> attrs = BasicFileAttributesUtil.cleanup(_attrs);
            attrs = DublinCoreAttributesUtil.cleanup((Map)attrs);
            attrs = DiscussionAttributesUtil.cleanup(attrs);
            attrs = OtherMetaAttributesUtil.cleanup(attrs);
            attrs.putAll(DiscussionAttributesUtil.toMap(new DiscussionAttributes(){

                @Override
                public List<DiscussionRecord> discussion() {
                    return metadata.getDiscussion();
                }

                public FileTime lastModifiedTime() {
                    return null;
                }

                public FileTime lastAccessTime() {
                    return null;
                }

                public FileTime creationTime() {
                    return null;
                }

                public boolean isRegularFile() {
                    return false;
                }

                public boolean isDirectory() {
                    return false;
                }

                public boolean isSymbolicLink() {
                    return false;
                }

                public boolean isOther() {
                    return false;
                }

                public long size() {
                    return 0L;
                }

                public Object fileKey() {
                    return null;
                }
            }, "*"));
            attrs.putAll(OtherMetaAttributesUtil.toMap(new OtherMetaAttributes(){

                @Override
                public List<String> categories() {
                    return metadata.getCategories();
                }

                public FileTime lastModifiedTime() {
                    return null;
                }

                public FileTime lastAccessTime() {
                    return null;
                }

                public FileTime creationTime() {
                    return null;
                }

                public boolean isRegularFile() {
                    return false;
                }

                public boolean isDirectory() {
                    return false;
                }

                public boolean isSymbolicLink() {
                    return false;
                }

                public boolean isOther() {
                    return false;
                }

                public long size() {
                    return 0L;
                }

                public Object fileKey() {
                    return null;
                }
            }, "*"));
            attrs.putAll(DublinCoreAttributesUtil.toMap((DublinCoreAttributes)new DublinCoreAttributes(){

                public List<String> titles() {
                    return Collections.emptyList();
                }

                public List<String> creators() {
                    return Collections.emptyList();
                }

                public List<String> subjects() {
                    return new ArrayList<String>(1){
                        {
                            this.add(metadata.getSubject());
                        }
                    };
                }

                public List<String> descriptions() {
                    return new ArrayList<String>(1){
                        {
                            this.add(metadata.getDescription());
                        }
                    };
                }

                public List<String> publishers() {
                    return Collections.emptyList();
                }

                public List<String> contributors() {
                    return Collections.emptyList();
                }

                public List<String> types() {
                    return new ArrayList<String>(1){
                        {
                            this.add(metadata.getType());
                        }
                    };
                }

                public List<String> formats() {
                    return Collections.emptyList();
                }

                public List<String> identifiers() {
                    return Collections.emptyList();
                }

                public List<String> sources() {
                    return new ArrayList<String>(1){
                        {
                            this.add(metadata.getExternalSource());
                        }
                    };
                }

                public List<String> languages() {
                    return Collections.emptyList();
                }

                public List<String> relations() {
                    return new ArrayList<String>(1){
                        {
                            this.add(metadata.getExternalRelation());
                        }
                    };
                }

                public List<String> coverages() {
                    return Collections.emptyList();
                }

                public List<String> rights() {
                    return Collections.emptyList();
                }

                public FileTime lastModifiedTime() {
                    return null;
                }

                public FileTime lastAccessTime() {
                    return null;
                }

                public FileTime creationTime() {
                    return null;
                }

                public boolean isRegularFile() {
                    return false;
                }

                public boolean isDirectory() {
                    return false;
                }

                public boolean isSymbolicLink() {
                    return false;
                }

                public boolean isOther() {
                    return false;
                }

                public long size() {
                    return 0L;
                }

                public Object fileKey() {
                    return null;
                }
            }, (String[])new String[]{"*"}));
            return attrs;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public Map<String, Object> setUpAttributes(org.uberfire.backend.vfs.Path path, Metadata metadata) {
        try {
            Map<String, Object> attributes;
            try {
                attributes = this.ioService.readAttributes(Paths.convert((org.uberfire.backend.vfs.Path)path));
            }
            catch (NoSuchFileException ex) {
                attributes = new HashMap<String, Object>();
            }
            if (metadata != null) {
                attributes = this.configAttrs(attributes, metadata);
            }
            return BasicFileAttributesUtil.cleanup(attributes);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }
}

