/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.version;

import java.net.URISyntaxException;
import java.util.List;
import javax.inject.Inject;
import org.guvnor.common.services.backend.version.PathResolver;
import org.guvnor.common.services.backend.version.VersionLoader;
import org.guvnor.common.services.backend.version.VersionUtil;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.Path;

public class PathResolverImpl
implements PathResolver {
    private VersionLoader versionLoader;
    private VersionUtil util;

    public PathResolverImpl() {
    }

    @Inject
    public PathResolverImpl(VersionLoader versionLoader, VersionUtil util) {
        this.util = util;
        this.versionLoader = versionLoader;
    }

    public Path resolveMainFilePath(Path path) throws URISyntaxException {
        if (this.isDotFile(path)) {
            Path mainPath = this.getMainPath(path);
            VersionRecord currentMainRecord = this.versionLoader.loadRecord(path);
            List<VersionRecord> versionRecords = this.versionLoader.loadVersionRecords(mainPath);
            for (VersionRecord versionRecord : versionRecords) {
                if (versionRecord.date().compareTo(currentMainRecord.date()) < 0) continue;
                return this.util.getPath(mainPath, versionRecord.id());
            }
            return mainPath;
        }
        return path;
    }

    public Path resolveDotFilePath(Path convert) {
        return null;
    }

    private Path getMainPath(Path path) {
        return path.resolveSibling(this.util.getFileName(path).substring(1));
    }

    public boolean isDotFile(Path path) {
        return this.util.getFileName(path).startsWith(".");
    }
}

