/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.metadata;

import java.util.ArrayList;
import java.util.Date;
import org.guvnor.common.services.backend.metadata.DiscussionAttributesMock;
import org.guvnor.common.services.backend.metadata.DublinCoreAttributesMock;
import org.guvnor.common.services.backend.metadata.MetadataCreator;
import org.guvnor.common.services.backend.metadata.OtherMetaAttributesMock;
import org.guvnor.common.services.backend.metadata.VersionAttributesMock;
import org.guvnor.common.services.backend.metadata.attribute.DiscussionView;
import org.guvnor.common.services.backend.metadata.attribute.OtherMetaView;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.io.IOService;
import org.uberfire.io.attribute.DublinCoreView;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;
import org.uberfire.rpc.impl.SessionInfoWrapper;

@RunWith(value=MockitoJUnitRunner.class)
public class MetadataCreatorTest {
    private SimpleFileSystemProvider fileSystemProvider;
    @Mock
    private IOService configIOService;
    @Mock
    private SessionInfoWrapper sessionInfo;
    @Mock
    private DublinCoreView dcoreView;
    @Mock
    private DiscussionView discussView;
    @Mock
    private OtherMetaView otherMetaView;
    @Mock
    private VersionAttributeView versionAttributeView;
    private MetadataCreator service;
    private Path mainFilePath;
    private ArrayList<VersionRecord> versionRecords;

    @Before
    public void setUp() throws Exception {
        this.versionRecords = new ArrayList();
        VersionAttributesMock versionAttributes = new VersionAttributesMock(this.versionRecords);
        Mockito.when((Object)this.versionAttributeView.readAttributes()).thenReturn((Object)versionAttributes);
        Mockito.when((Object)this.dcoreView.readAttributes()).thenReturn((Object)new DublinCoreAttributesMock());
        Mockito.when((Object)this.otherMetaView.readAttributes()).thenReturn((Object)new OtherMetaAttributesMock());
        Mockito.when((Object)this.discussView.readAttributes()).thenReturn((Object)new DiscussionAttributesMock());
        this.fileSystemProvider = new SimpleFileSystemProvider();
        this.fileSystemProvider.forceAsDefault();
        this.mainFilePath = this.fileSystemProvider.getPath(this.getClass().getResource("myfile.file").toURI());
        this.service = new MetadataCreator(this.mainFilePath, this.configIOService, this.sessionInfo, this.dcoreView, this.discussView, this.otherMetaView, this.versionAttributeView);
    }

    @Test
    public void testSimple() throws Exception {
        this.versionRecords.add(this.createVersionRecord());
        Metadata metadata = this.service.create();
        Assert.assertNotNull((Object)metadata);
        Assert.assertNotNull((Object)metadata.getCategories());
        Assert.assertNotNull((Object)metadata.getDiscussion());
        Assert.assertNotNull((Object)metadata.getVersion());
    }

    private VersionRecord createVersionRecord() {
        return new VersionRecord(){

            public String id() {
                return "1";
            }

            public String author() {
                return "admin";
            }

            public String email() {
                return "admin@mail.zap";
            }

            public String comment() {
                return "Some commit";
            }

            public Date date() {
                return new Date();
            }

            public String uri() {
                return "myfile.file";
            }
        };
    }
}

