/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.metadata;

import com.thoughtworks.xstream.XStream;
import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.shared.metadata.CategoriesService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Categories;
import org.guvnor.common.services.shared.metadata.model.CategoriesModelContent;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;

@Service
@ApplicationScoped
public class CategoryServiceImpl
implements CategoriesService {
    private final XStream xt = new XStream();
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private MetadataService metadataService;
    @Inject
    private User identity;
    @Inject
    private SessionInfo sessionInfo;

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path path, Categories content, Metadata metadata, String comment) {
        return Paths.convert((Path)this.saveWithServerSidePath(Paths.convert((org.uberfire.backend.vfs.Path)path), content, metadata, comment));
    }

    private Path saveWithServerSidePath(Path path, Categories content) {
        return this.saveWithServerSidePath(path, content, null, "");
    }

    private Path saveWithServerSidePath(Path path, Categories content, Metadata metadata, String comment) {
        try {
            this.ioService.write(path, this.xt.toXML((Object)content), this.metadataService.setUpAttributes(Paths.convert((Path)path), metadata), new OpenOption[]{this.makeCommentedOption(comment)});
            return path;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getIdentifier();
        Date when = new Date();
        return new CommentedOption(this.getSessionInfo().getId(), name, null, commitMessage, when);
    }

    public Categories load(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            Categories categories = content.trim().equals("") ? new Categories() : (Categories)this.xt.fromXML(content);
            return categories;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public CategoriesModelContent getContentByRoot(org.uberfire.backend.vfs.Path pathToRoot) {
        Path path = Paths.convert((org.uberfire.backend.vfs.Path)pathToRoot).resolve("categories.xml");
        if (!this.ioService.exists(path)) {
            this.saveWithServerSidePath(path, new Categories());
        }
        org.uberfire.backend.vfs.Path categoriesPath = Paths.convert((Path)path);
        return new CategoriesModelContent(categoriesPath, this.load(categoriesPath), this.loadOverview(categoriesPath));
    }

    protected Overview loadOverview(org.uberfire.backend.vfs.Path path) {
        Overview overview = new Overview();
        overview.setMetadata(this.metadataService.getMetadata(path));
        overview.setProjectName("");
        return overview;
    }

    public Categories getCategoriesFromResource(org.uberfire.backend.vfs.Path resource) {
        try {
            Path categoriesPath = Paths.convert((org.uberfire.backend.vfs.Path)resource).getRoot().resolve("categories.xml");
            return this.load(Paths.convert((Path)categoriesPath));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    protected SessionInfo getSessionInfo() {
        return new SafeSessionInfo(this.sessionInfo);
    }
}

