/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.metadata;

import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.guvnor.common.services.backend.metadata.DiscussionAttributesMock;
import org.guvnor.common.services.backend.metadata.DublinCoreAttributesMock;
import org.guvnor.common.services.backend.metadata.MetadataCreator;
import org.guvnor.common.services.backend.metadata.OtherMetaAttributesMock;
import org.guvnor.common.services.backend.metadata.VersionAttributesMock;
import org.guvnor.common.services.backend.metadata.attribute.DiscussionView;
import org.guvnor.common.services.backend.metadata.attribute.OtherMetaView;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.uberfire.io.IOService;
import org.uberfire.io.attribute.DublinCoreView;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.api.FileSystemProviders;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;
import org.uberfire.rpc.SessionInfo;

@RunWith(value=MockitoJUnitRunner.class)
public class MetadataCreatorTest {
    private SimpleFileSystemProvider fileSystemProvider;
    @Mock
    private IOService configIOService;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private DublinCoreView dcoreView;
    @Mock
    private DiscussionView discussView;
    @Mock
    private OtherMetaView otherMetaView;
    @Mock
    private VersionAttributeView versionAttributeView;
    private MetadataCreator service;
    private Path mainFilePath;
    private ArrayList<VersionRecord> versionRecords;

    @Before
    public void setUp() throws Exception {
        this.versionRecords = new ArrayList();
        this.versionRecords.add(this.createVersionRecord());
        VersionAttributesMock versionAttributes = new VersionAttributesMock(this.versionRecords);
        Mockito.when((Object)this.versionAttributeView.readAttributes()).thenReturn((Object)versionAttributes);
        Mockito.when((Object)this.dcoreView.readAttributes()).thenReturn((Object)new DublinCoreAttributesMock());
        Mockito.when((Object)this.otherMetaView.readAttributes()).thenReturn((Object)new OtherMetaAttributesMock());
        Mockito.when((Object)this.discussView.readAttributes()).thenReturn((Object)new DiscussionAttributesMock());
        this.fileSystemProvider = new SimpleFileSystemProvider();
        this.fileSystemProvider.forceAsDefault();
        this.mainFilePath = this.fileSystemProvider.getPath(this.getClass().getResource("myfile.file").toURI());
        this.service = new MetadataCreator(this.mainFilePath, this.configIOService, this.sessionInfo, this.dcoreView, this.discussView, this.otherMetaView, this.versionAttributeView);
    }

    @Test
    public void testSimple() throws Exception {
        Metadata metadata = this.service.create();
        Assert.assertNotNull((Object)metadata);
        Assert.assertNotNull((Object)metadata.getTags());
        Assert.assertNotNull((Object)metadata.getDiscussion());
        Assert.assertNotNull((Object)metadata.getVersion());
    }

    @Test
    public void testConcurrency() throws Throwable {
        FileSystemProviders.getDefaultProvider();
        final AtomicBoolean exists = new AtomicBoolean(false);
        Mockito.when((Object)this.configIOService.exists((Path)Matchers.any(Path.class))).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return exists.get();
            }
        });
        Mockito.when((Object)this.configIOService.write((Path)Matchers.any(Path.class), (String)Matchers.any(String.class), new OpenOption[0])).thenAnswer((Answer)new Answer<Path>(){

            public Path answer(InvocationOnMock invocation) throws Throwable {
                exists.set(true);
                return MetadataCreatorTest.this.mainFilePath;
            }
        });
        Mockito.when((Object)this.configIOService.readAllString((Path)Matchers.any(Path.class))).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                if (!exists.get()) {
                    throw new NoSuchFileException();
                }
                return "content";
            }
        });
        ((IOService)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                exists.set(false);
                return null;
            }
        }).when((Object)this.configIOService)).delete((Path)Matchers.any(Path.class), new DeleteOption[0]);
        int THREADS = 100;
        final Result result = new Result();
        ExecutorService es = Executors.newCachedThreadPool();
        for (int i = 0; i < 100; ++i) {
            final int threadCount = i;
            final Operation op = i % 2 == 1 ? Operation.WRITE : Operation.CHECK;
            es.execute(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    try {
                        System.out.println("[Thread : " + threadCount + "] Running...");
                        switch (op) {
                            case WRITE: {
                                System.out.println("[Thread : " + threadCount + "] Writing..." + this.output());
                                MetadataCreatorTest.this.configIOService.write(MetadataCreatorTest.this.mainFilePath, "content", new OpenOption[0]);
                                MetadataCreatorTest.this.configIOService.delete(MetadataCreatorTest.this.mainFilePath, new DeleteOption[0]);
                                return;
                            }
                            case CHECK: {
                                System.out.println("[Thread : " + threadCount + "] Checking..." + this.output());
                                MetadataCreatorTest.this.service.create();
                                return;
                            }
                        }
                        return;
                    }
                    catch (Throwable e) {
                        result.setFailed(true);
                        result.setException(e);
                        return;
                    }
                    finally {
                        System.out.println("[Thread : " + threadCount + "] Completed.");
                    }
                }

                private String output() {
                    if (exists.get()) {
                        return "Exists";
                    }
                    return "Not exists";
                }
            });
        }
        try {
            es.shutdown();
            es.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (result.isFailed()) {
            throw result.getException();
        }
    }

    private VersionRecord createVersionRecord() {
        return new VersionRecord(){

            public String id() {
                return "1";
            }

            public String author() {
                return "admin";
            }

            public String email() {
                return "admin@mail.zap";
            }

            public String comment() {
                return "Some commit";
            }

            public Date date() {
                return new Date();
            }

            public String uri() {
                return "myfile.file";
            }
        };
    }

    private static class Result {
        private Throwable exception;
        private boolean failed = false;

        private Result() {
        }

        public Throwable getException() {
            return this.exception;
        }

        public void setException(Throwable exception) {
            this.exception = exception;
        }

        public boolean isFailed() {
            return this.failed;
        }

        public void setFailed(boolean failed) {
            this.failed = failed;
        }
    }

    private static enum Operation {
        WRITE,
        CHECK;

    }
}

