/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.file;

import org.guvnor.common.services.backend.file.DotFileFilter;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

public class FileExtensionFilter
extends DotFileFilter {
    private String extension;

    public FileExtensionFilter(String extension) {
        this.extension = (String)PortablePreconditions.checkNotNull((String)"extension", (Object)extension);
        if (!extension.startsWith(".")) {
            this.extension = "." + extension;
        }
    }

    @Override
    public boolean accept(Path path) {
        boolean accept = super.accept(path);
        if (accept) {
            return false;
        }
        if (!Files.isRegularFile((Path)path, (LinkOption[])new LinkOption[0])) {
            return false;
        }
        String uri = path.toUri().toString();
        return uri.substring(uri.length() - this.extension.length()).equals(this.extension);
    }
}

