/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.metadata.MetadataCreator;
import org.guvnor.common.services.backend.metadata.MetadataServerSideService;
import org.guvnor.common.services.backend.metadata.attribute.DiscussionAttributes;
import org.guvnor.common.services.backend.metadata.attribute.DiscussionAttributesUtil;
import org.guvnor.common.services.backend.metadata.attribute.DiscussionView;
import org.guvnor.common.services.backend.metadata.attribute.GeneratedAttributesUtil;
import org.guvnor.common.services.backend.metadata.attribute.GeneratedAttributesView;
import org.guvnor.common.services.backend.metadata.attribute.OtherMetaAttributes;
import org.guvnor.common.services.backend.metadata.attribute.OtherMetaAttributesUtil;
import org.guvnor.common.services.backend.metadata.attribute.OtherMetaView;
import org.guvnor.common.services.shared.metadata.model.DiscussionRecord;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.io.IOService;
import org.uberfire.io.attribute.DublinCoreAttributes;
import org.uberfire.io.attribute.DublinCoreAttributesUtil;
import org.uberfire.io.attribute.DublinCoreView;
import org.uberfire.java.nio.base.BasicFileAttributesUtil;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileTime;
import org.uberfire.rpc.SessionInfo;

@Service
@ApplicationScoped
public class MetadataServiceImpl
implements MetadataServerSideService {
    private IOService ioService;
    private IOService configIOService;
    private SessionInfo sessionInfo;

    public MetadataServiceImpl() {
    }

    @Inject
    public MetadataServiceImpl(@Named(value="ioStrategy") IOService ioService, @Named(value="configIO") IOService configIOService, SessionInfo sessionInfo) {
        this.ioService = ioService;
        this.configIOService = configIOService;
        this.sessionInfo = sessionInfo;
    }

    public Metadata getMetadata(org.uberfire.backend.vfs.Path pathToResource) {
        return this.getMetadata(Paths.convert((org.uberfire.backend.vfs.Path)pathToResource));
    }

    public Metadata getMetadata(Path path) {
        try {
            return new MetadataCreator(path, this.configIOService, this.sessionInfo, (DublinCoreView)this.ioService.getFileAttributeView(path, DublinCoreView.class), (DiscussionView)this.ioService.getFileAttributeView(path, DiscussionView.class), (OtherMetaView)this.ioService.getFileAttributeView(path, OtherMetaView.class), (VersionAttributeView)this.ioService.getFileAttributeView(path, VersionAttributeView.class), (GeneratedAttributesView)this.ioService.getFileAttributeView(path, GeneratedAttributesView.class)).create();
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public List<String> getTags(org.uberfire.backend.vfs.Path resource) {
        PortablePreconditions.checkNotNull((String)"resource", (Object)resource);
        return this.getTags(Paths.convert((org.uberfire.backend.vfs.Path)resource));
    }

    public List<String> getTags(Path resource) {
        PortablePreconditions.checkNotNull((String)"resource", (Object)resource);
        OtherMetaView otherMetaView = (OtherMetaView)this.ioService.getFileAttributeView(resource, OtherMetaView.class);
        if (otherMetaView != null) {
            return otherMetaView.readAttributes().tags();
        }
        return Collections.emptyList();
    }

    public Map<String, Object> configAttrs(Map<String, Object> _attrs, final Metadata metadata) {
        try {
            PortablePreconditions.checkNotNull((String)"_attrs", _attrs);
            PortablePreconditions.checkNotNull((String)"metadata", (Object)metadata);
            Map<String, Object> attrs = BasicFileAttributesUtil.cleanup(_attrs);
            attrs = DublinCoreAttributesUtil.cleanup((Map)attrs);
            attrs = DiscussionAttributesUtil.cleanup(attrs);
            attrs = OtherMetaAttributesUtil.cleanup(attrs);
            attrs = GeneratedAttributesUtil.cleanup(attrs);
            attrs.putAll(DiscussionAttributesUtil.toMap(new DiscussionAttributes(){

                @Override
                public List<DiscussionRecord> discussion() {
                    return metadata.getDiscussion();
                }

                public FileTime lastModifiedTime() {
                    return null;
                }

                public FileTime lastAccessTime() {
                    return null;
                }

                public FileTime creationTime() {
                    return null;
                }

                public boolean isRegularFile() {
                    return false;
                }

                public boolean isDirectory() {
                    return false;
                }

                public boolean isSymbolicLink() {
                    return false;
                }

                public boolean isOther() {
                    return false;
                }

                public long size() {
                    return 0L;
                }

                public Object fileKey() {
                    return null;
                }
            }, "*"));
            attrs.putAll(OtherMetaAttributesUtil.toMap(new OtherMetaAttributes(){

                @Override
                public List<String> tags() {
                    return metadata.getTags();
                }

                public FileTime lastModifiedTime() {
                    return null;
                }

                public FileTime lastAccessTime() {
                    return null;
                }

                public FileTime creationTime() {
                    return null;
                }

                public boolean isRegularFile() {
                    return false;
                }

                public boolean isDirectory() {
                    return false;
                }

                public boolean isSymbolicLink() {
                    return false;
                }

                public boolean isOther() {
                    return false;
                }

                public long size() {
                    return 0L;
                }

                public Object fileKey() {
                    return null;
                }
            }, "*"));
            attrs.putAll(DublinCoreAttributesUtil.toMap((DublinCoreAttributes)new DublinCoreAttributes(){

                public List<String> titles() {
                    return Collections.emptyList();
                }

                public List<String> creators() {
                    return Collections.emptyList();
                }

                public List<String> subjects() {
                    return new ArrayList<String>(1){
                        {
                            this.add(metadata.getSubject());
                        }
                    };
                }

                public List<String> descriptions() {
                    return new ArrayList<String>(1){
                        {
                            this.add(metadata.getDescription());
                        }
                    };
                }

                public List<String> publishers() {
                    return Collections.emptyList();
                }

                public List<String> contributors() {
                    return Collections.emptyList();
                }

                public List<String> types() {
                    return new ArrayList<String>(1){
                        {
                            this.add(metadata.getType());
                        }
                    };
                }

                public List<String> formats() {
                    return Collections.emptyList();
                }

                public List<String> identifiers() {
                    return Collections.emptyList();
                }

                public List<String> sources() {
                    return new ArrayList<String>(1){
                        {
                            this.add(metadata.getExternalSource());
                        }
                    };
                }

                public List<String> languages() {
                    return Collections.emptyList();
                }

                public List<String> relations() {
                    return new ArrayList<String>(1){
                        {
                            this.add(metadata.getExternalRelation());
                        }
                    };
                }

                public List<String> coverages() {
                    return Collections.emptyList();
                }

                public List<String> rights() {
                    return Collections.emptyList();
                }

                public FileTime lastModifiedTime() {
                    return null;
                }

                public FileTime lastAccessTime() {
                    return null;
                }

                public FileTime creationTime() {
                    return null;
                }

                public boolean isRegularFile() {
                    return false;
                }

                public boolean isDirectory() {
                    return false;
                }

                public boolean isSymbolicLink() {
                    return false;
                }

                public boolean isOther() {
                    return false;
                }

                public long size() {
                    return 0L;
                }

                public Object fileKey() {
                    return null;
                }
            }, (String[])new String[]{"*"}));
            if (metadata.isGenerated()) {
                attrs.put("generated.generated", true);
            }
            return attrs;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public Map<String, Object> setUpAttributes(org.uberfire.backend.vfs.Path path, Metadata metadata) {
        try {
            Map<String, Object> attributes;
            try {
                attributes = this.ioService.readAttributes(Paths.convert((org.uberfire.backend.vfs.Path)path));
            }
            catch (NoSuchFileException ex) {
                attributes = new HashMap<String, Object>();
            }
            if (metadata != null) {
                attributes = this.configAttrs(attributes, metadata);
            }
            return BasicFileAttributesUtil.cleanup(attributes);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }
}

