/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.migration;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.security.ProjectAction;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.security.OrganizationalUnitAction;
import org.guvnor.structure.security.RepositoryAction;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.uberfire.backend.authz.AuthorizationPolicyStorage;
import org.uberfire.backend.events.AuthorizationPolicyDeployedEvent;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;

@ApplicationScoped
public class ACLMigrationTool {
    private OrganizationalUnitService organizationalUnitService;
    private RepositoryService repositoryService;
    private Instance<ProjectService<?>> projectServices;
    private PermissionManager permissionManager;
    private AuthorizationPolicyStorage authorizationPolicyStorage;
    private Map<String, Group> groupMap = new HashMap<String, Group>();

    @Inject
    public ACLMigrationTool(OrganizationalUnitService organizationalUnitService, RepositoryService repositoryService, Instance<ProjectService<?>> projectServices, PermissionManager permissionManager, AuthorizationPolicyStorage authorizationPolicyStorage) {
        this.organizationalUnitService = organizationalUnitService;
        this.repositoryService = repositoryService;
        this.projectServices = projectServices;
        this.permissionManager = permissionManager;
        this.authorizationPolicyStorage = authorizationPolicyStorage;
    }

    public void onDeploy(@Observes AuthorizationPolicyDeployedEvent event) {
        AuthorizationPolicy policy = event.getPolicy();
        this.migrateOrgUnits(policy);
        this.migrateRepositories(policy);
        this.authorizationPolicyStorage.savePolicy(policy);
    }

    private Group getGroup(String groupName) {
        Group group = this.groupMap.get(groupName);
        if (group == null) {
            group = new GroupImpl(groupName);
            this.groupMap.put(groupName, group);
        }
        return group;
    }

    public void migrateOrgUnits(AuthorizationPolicy policy) {
        Collection itemList = this.organizationalUnitService.getAllOrganizationalUnits();
        for (OrganizationalUnit item : itemList) {
            Permission p = this.permissionManager.createPermission((Resource)item, OrganizationalUnitAction.READ, true);
            for (String groupName : item.getGroups()) {
                Group group = this.getGroup(groupName);
                PermissionCollection pc = policy.getPermissions(group);
                pc.add(new Permission[]{p});
            }
        }
    }

    public void migrateRepositories(AuthorizationPolicy policy) {
        Collection itemList = this.repositoryService.getAllRepositories();
        for (Repository item : itemList) {
            Permission p = this.permissionManager.createPermission((Resource)item, RepositoryAction.READ, true);
            for (String groupName : item.getGroups()) {
                Group group = this.getGroup(groupName);
                PermissionCollection pc = policy.getPermissions(group);
                pc.add(new Permission[]{p});
            }
            this.migrateProjects(policy, item);
        }
    }

    public void migrateProjects(AuthorizationPolicy policy, Repository repository) {
        ProjectService projectService = this.getProjectService();
        if (projectService != null) {
            Set itemList = projectService.getAllProjects(repository, "master");
            for (Project item : itemList) {
                Permission p = this.permissionManager.createPermission((Resource)item, ProjectAction.READ, true);
                for (String groupName : item.getGroups()) {
                    Group group = this.getGroup(groupName);
                    PermissionCollection pc = policy.getPermissions(group);
                    pc.add(new Permission[]{p});
                }
            }
        }
    }

    public ProjectService getProjectService() {
        return (ProjectService)this.projectServices.get();
    }
}

