/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories.git;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.impl.DefaultPublicURI;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.PasswordService;
import org.guvnor.structure.server.config.SecureConfigItem;
import org.guvnor.structure.server.repositories.RepositoryFactoryHelper;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class GitRepositoryFactoryHelper
implements RepositoryFactoryHelper {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private PasswordService secureService;

    public boolean accept(ConfigGroup repoConfig) {
        Preconditions.checkNotNull((String)"repoConfig", (Object)repoConfig);
        ConfigItem schemeConfigItem = repoConfig.getConfigItem("scheme");
        Preconditions.checkNotNull((String)"schemeConfigItem", (Object)schemeConfigItem);
        return "git".equals(schemeConfigItem.getValue());
    }

    public Repository newRepository(ConfigGroup repoConfig) {
        Preconditions.checkNotNull((String)"repoConfig", (Object)repoConfig);
        ConfigItem schemeConfigItem = repoConfig.getConfigItem("scheme");
        Preconditions.checkNotNull((String)"schemeConfigItem", (Object)schemeConfigItem);
        String branch = repoConfig.getConfigItemValue("branch");
        if (branch == null) {
            branch = "master";
        }
        final GitRepository repo = new GitRepository(repoConfig.getName());
        repo.setCurrentBranch(branch);
        for (ConfigItem item : repoConfig.getItems()) {
            if (item instanceof SecureConfigItem) {
                repo.addEnvironmentParameter(item.getName(), (Object)this.secureService.decrypt(item.getValue().toString()));
                continue;
            }
            repo.addEnvironmentParameter(item.getName(), item.getValue());
        }
        if (!repo.isValid()) {
            throw new IllegalStateException("Repository " + repoConfig.getName() + " not valid");
        }
        FileSystem fs = null;
        URI uri = null;
        try {
            uri = URI.create(repo.getUri());
            fs = this.ioService.newFileSystem(uri, (Map)new HashMap<String, Object>(repo.getEnvironment()){
                {
                    super(x0);
                    if (!repo.getEnvironment().containsKey("origin")) {
                        this.put("init", true);
                    }
                }
            });
        }
        catch (FileSystemAlreadyExistsException e) {
            fs = this.ioService.getFileSystem(uri);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex.getCause().getMessage(), ex);
        }
        Path defaultRoot = (Path)fs.getRootDirectories().iterator().next();
        for (Path path : fs.getRootDirectories()) {
            String gitBranch = this.getBranchName(path);
            if (!gitBranch.equals(branch)) continue;
            defaultRoot = path;
            break;
        }
        HashSet<String> branches = new HashSet<String>();
        for (Path path : fs.getRootDirectories()) {
            String gitBranch = this.getBranchName(path);
            branches.add(gitBranch);
        }
        repo.setBranches(branches);
        repo.setRoot(Paths.convert((Path)defaultRoot));
        String[] uris = fs.toString().split("\\r?\\n");
        ArrayList<DefaultPublicURI> publicURIs = new ArrayList<DefaultPublicURI>(uris.length);
        for (String s : uris) {
            int protocolStart = s.indexOf("://");
            DefaultPublicURI publicURI = protocolStart > 0 ? new DefaultPublicURI(s.substring(0, protocolStart), s) : new DefaultPublicURI(s);
            publicURIs.add(publicURI);
        }
        repo.setPublicURIs(publicURIs);
        return repo;
    }

    protected String getBranchName(Path path) {
        String gitBranch = path.toUri().getAuthority();
        if (gitBranch.indexOf("@") != -1) {
            return gitBranch.split("@")[0];
        }
        return gitBranch;
    }
}

