/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.structure.backend.config.OrgUnit;
import org.guvnor.structure.backend.config.SystemRepositoryChangedEvent;
import org.guvnor.structure.organizationalunit.NewOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.RemoveOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.RepoAddedToOrganizationaUnitEvent;
import org.guvnor.structure.organizationalunit.RepoRemovedFromOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.UpdatedOrganizationalUnitEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryUpdatedEvent;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.organizationalunit.OrganizationalUnitFactory;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.rpc.SessionInfo;

@Service
@ApplicationScoped
public class OrganizationalUnitServiceImpl
implements OrganizationalUnitService {
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private OrganizationalUnitFactory organizationalUnitFactory;
    @Inject
    private Event<NewOrganizationalUnitEvent> newOrganizationalUnitEvent;
    @Inject
    private Event<RemoveOrganizationalUnitEvent> removeOrganizationalUnitEvent;
    @Inject
    private Event<RepoAddedToOrganizationaUnitEvent> repoAddedToOrgUnitEvent;
    @Inject
    private Event<RepoRemovedFromOrganizationalUnitEvent> repoRemovedFromOrgUnitEvent;
    @Inject
    private Event<UpdatedOrganizationalUnitEvent> updatedOrganizationalUnitEvent;
    private Map<String, OrganizationalUnit> registeredOrganizationalUnits = new HashMap<String, OrganizationalUnit>();
    @Inject
    private SessionInfo sessionInfo;

    @PostConstruct
    public void loadOrganizationalUnits() {
        List groups = this.configurationService.getConfiguration(ConfigType.ORGANIZATIONAL_UNIT);
        if (groups != null) {
            for (ConfigGroup groupConfig : groups) {
                OrganizationalUnit ou = this.organizationalUnitFactory.newOrganizationalUnit(groupConfig);
                this.registeredOrganizationalUnits.put(ou.getName(), ou);
            }
        }
    }

    public OrganizationalUnit getOrganizationalUnit(String name) {
        return this.registeredOrganizationalUnits.get(name);
    }

    public Collection<OrganizationalUnit> getOrganizationalUnits() {
        return new ArrayList<OrganizationalUnit>(this.registeredOrganizationalUnits.values());
    }

    public OrganizationalUnit createOrganizationalUnit(String name, String owner) {
        ConfigGroup groupConfig = this.configurationFactory.newConfigGroup(ConfigType.ORGANIZATIONAL_UNIT, name, "");
        groupConfig.addConfigItem(this.configurationFactory.newConfigItem("owner", owner));
        groupConfig.addConfigItem(this.configurationFactory.newConfigItem("repositories", new ArrayList()));
        groupConfig.addConfigItem(this.configurationFactory.newConfigItem("security:roles", new ArrayList()));
        this.configurationService.addConfiguration(groupConfig);
        OrganizationalUnit newOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(groupConfig);
        this.registeredOrganizationalUnits.put(newOrganizationalUnit.getName(), newOrganizationalUnit);
        this.newOrganizationalUnitEvent.fire((Object)new NewOrganizationalUnitEvent(newOrganizationalUnit, this.sessionInfo));
        return newOrganizationalUnit;
    }

    public OrganizationalUnit createOrganizationalUnit(String name, String owner, Collection<Repository> repositories) {
        ConfigGroup groupConfig = this.configurationFactory.newConfigGroup(ConfigType.ORGANIZATIONAL_UNIT, name, "");
        groupConfig.addConfigItem(this.configurationFactory.newConfigItem("owner", owner));
        groupConfig.addConfigItem(this.configurationFactory.newConfigItem("repositories", this.getRepositoryAliases(repositories)));
        groupConfig.addConfigItem(this.configurationFactory.newConfigItem("security:roles", new ArrayList()));
        this.configurationService.addConfiguration(groupConfig);
        OrganizationalUnit newOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(groupConfig);
        this.registeredOrganizationalUnits.put(newOrganizationalUnit.getName(), newOrganizationalUnit);
        this.newOrganizationalUnitEvent.fire((Object)new NewOrganizationalUnitEvent(newOrganizationalUnit, this.sessionInfo));
        return newOrganizationalUnit;
    }

    private List<String> getRepositoryAliases(Collection<Repository> repositories) {
        ArrayList<String> repositoryList = new ArrayList<String>();
        for (Repository repo : repositories) {
            repositoryList.add(repo.getAlias());
        }
        return repositoryList;
    }

    public void updateOrganizationalUnitOwner(String name, String owner) {
        ConfigGroup thisGroupConfig = this.findGroupConfig(name);
        if (thisGroupConfig == null) {
            throw new IllegalArgumentException("OrganizationalUnit " + name + " not found");
        }
        thisGroupConfig.setConfigItem(this.configurationFactory.newConfigItem("owner", owner));
        this.configurationService.updateConfiguration(thisGroupConfig);
        OrganizationalUnit updatedOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(thisGroupConfig);
        this.registeredOrganizationalUnits.put(updatedOrganizationalUnit.getName(), updatedOrganizationalUnit);
        this.updatedOrganizationalUnitEvent.fire((Object)new UpdatedOrganizationalUnitEvent(updatedOrganizationalUnit, this.sessionInfo));
    }

    public void addRepository(OrganizationalUnit organizationalUnit, Repository repository) {
        ConfigGroup thisGroupConfig = this.findGroupConfig(organizationalUnit.getName());
        if (thisGroupConfig == null) {
            throw new IllegalArgumentException("OrganizationalUnit " + organizationalUnit.getName() + " not found");
        }
        ConfigItem repositories = thisGroupConfig.getConfigItem("repositories");
        ((List)repositories.getValue()).add(repository.getAlias());
        this.configurationService.updateConfiguration(thisGroupConfig);
        OrganizationalUnit updatedOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(thisGroupConfig);
        this.registeredOrganizationalUnits.put(updatedOrganizationalUnit.getName(), updatedOrganizationalUnit);
        this.repoAddedToOrgUnitEvent.fire((Object)new RepoAddedToOrganizationaUnitEvent(organizationalUnit, repository, this.sessionInfo));
    }

    public void removeRepository(OrganizationalUnit organizationalUnit, Repository repository) {
        ConfigGroup thisGroupConfig = this.findGroupConfig(organizationalUnit.getName());
        if (thisGroupConfig == null) {
            throw new IllegalArgumentException("OrganizationalUnit " + organizationalUnit.getName() + " not found");
        }
        ConfigItem repositories = thisGroupConfig.getConfigItem("repositories");
        ((List)repositories.getValue()).remove(repository.getAlias());
        this.configurationService.updateConfiguration(thisGroupConfig);
        OrganizationalUnit updatedOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(thisGroupConfig);
        this.registeredOrganizationalUnits.put(updatedOrganizationalUnit.getName(), updatedOrganizationalUnit);
        this.repoRemovedFromOrgUnitEvent.fire((Object)new RepoRemovedFromOrganizationalUnitEvent(organizationalUnit, repository, this.sessionInfo));
    }

    public void addRole(OrganizationalUnit organizationalUnit, String role) {
        ConfigGroup thisGroupConfig = this.findGroupConfig(organizationalUnit.getName());
        if (thisGroupConfig == null) {
            throw new IllegalArgumentException("OrganizationalUnit " + organizationalUnit.getName() + " not found");
        }
        ConfigItem roles = thisGroupConfig.getConfigItem("security:roles");
        ((List)roles.getValue()).add(role);
        this.configurationService.updateConfiguration(thisGroupConfig);
        OrganizationalUnit updatedOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(thisGroupConfig);
        this.registeredOrganizationalUnits.put(updatedOrganizationalUnit.getName(), updatedOrganizationalUnit);
        this.updatedOrganizationalUnitEvent.fire((Object)new UpdatedOrganizationalUnitEvent(updatedOrganizationalUnit, this.sessionInfo));
    }

    public void removeRole(OrganizationalUnit organizationalUnit, String role) {
        ConfigGroup thisGroupConfig = this.findGroupConfig(organizationalUnit.getName());
        if (thisGroupConfig == null) {
            throw new IllegalArgumentException("OrganizationalUnit " + organizationalUnit.getName() + " not found");
        }
        ConfigItem roles = thisGroupConfig.getConfigItem("security:roles");
        ((List)roles.getValue()).remove(role);
        this.configurationService.updateConfiguration(thisGroupConfig);
        OrganizationalUnit updatedOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(thisGroupConfig);
        this.registeredOrganizationalUnits.put(updatedOrganizationalUnit.getName(), updatedOrganizationalUnit);
        this.updatedOrganizationalUnitEvent.fire((Object)new UpdatedOrganizationalUnitEvent(updatedOrganizationalUnit, this.sessionInfo));
    }

    protected ConfigGroup findGroupConfig(String name) {
        List groups = this.configurationService.getConfiguration(ConfigType.ORGANIZATIONAL_UNIT);
        if (groups != null) {
            for (ConfigGroup groupConfig : groups) {
                if (!groupConfig.getName().equals(name)) continue;
                return groupConfig;
            }
        }
        return null;
    }

    public void removeOrganizationalUnit(String groupName) {
        ConfigGroup thisGroupConfig = this.findGroupConfig(groupName);
        if (thisGroupConfig != null) {
            this.configurationService.removeConfiguration(thisGroupConfig);
            OrganizationalUnit ou = this.registeredOrganizationalUnits.remove(groupName);
            this.removeOrganizationalUnitEvent.fire((Object)new RemoveOrganizationalUnitEvent(ou, this.sessionInfo));
        }
    }

    public OrganizationalUnit getParentOrganizationalUnit(Repository repository) {
        for (OrganizationalUnit organizationalUnit : this.registeredOrganizationalUnits.values()) {
            if (organizationalUnit.getRepositories() == null || !organizationalUnit.getRepositories().contains(repository)) continue;
            return organizationalUnit;
        }
        return null;
    }

    public void updateRegisteredOU(@Observes @OrgUnit SystemRepositoryChangedEvent changedEvent) {
        this.registeredOrganizationalUnits.clear();
        this.loadOrganizationalUnits();
    }

    public void updateRegisteredOUonRepoChange(@Observes RepositoryUpdatedEvent changedEvent) {
        this.registeredOrganizationalUnits.clear();
        this.loadOrganizationalUnits();
    }
}

