/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.backcompat;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.backend.config.ConfigurationFactoryImpl;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.junit.Assert;
import org.junit.Test;

public class BackwardCompatibleUtilTest {
    @Test
    public void backwardCompatTest() {
        ConfigurationFactoryImpl factory = new ConfigurationFactoryImpl();
        BackwardCompatibleUtil backwardUtil = new BackwardCompatibleUtil((ConfigurationFactory)factory);
        Assert.assertNull((Object)backwardUtil.compat(null));
        ConfigGroup group1 = factory.newConfigGroup(ConfigType.PROJECT, "cool", "test");
        Assert.assertNotNull((Object)backwardUtil.compat(group1));
        Assert.assertNull((Object)backwardUtil.compat(group1).getConfigItem("security:groups"));
        group1.addConfigItem(factory.newConfigItem("security:groups", (List)new ArrayList(){
            {
                this.add("group1");
            }
        }));
        Assert.assertNotNull((Object)backwardUtil.compat(group1).getConfigItem("security:groups"));
        Assert.assertTrue((((List)backwardUtil.compat(group1).getConfigItem("security:groups").getValue()).size() == 1 ? 1 : 0) != 0);
        ConfigGroup group2 = factory.newConfigGroup(ConfigType.PROJECT, "cool2", "test2");
        Assert.assertNotNull((Object)backwardUtil.compat(group2));
        Assert.assertNull((Object)backwardUtil.compat(group2).getConfigItem("security:groups"));
        group2.addConfigItem(factory.newConfigItem("security:roles", (List)new ArrayList(){
            {
                this.add("group1");
            }
        }));
        Assert.assertNotNull((Object)backwardUtil.compat(group2).getConfigItem("security:groups"));
        Assert.assertTrue((((List)backwardUtil.compat(group2).getConfigItem("security:groups").getValue()).size() == 1 ? 1 : 0) != 0);
        Assert.assertNull((Object)backwardUtil.compat(group2).getConfigItem("security:roles"));
    }
}

