/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.backend.config.OrgUnit;
import org.guvnor.structure.config.SystemRepositoryChangedEvent;
import org.guvnor.structure.organizationalunit.NewOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.RemoveOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.RepoAddedToOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.RepoRemovedFromOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.UpdatedOrganizationalUnitEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentUpdatedEvent;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.organizationalunit.OrganizationalUnitFactory;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.rpc.SessionInfo;

@Service
@ApplicationScoped
public class OrganizationalUnitServiceImpl
implements OrganizationalUnitService {
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private OrganizationalUnitFactory organizationalUnitFactory;
    @Inject
    private BackwardCompatibleUtil backward;
    @Inject
    private Event<NewOrganizationalUnitEvent> newOrganizationalUnitEvent;
    @Inject
    private Event<RemoveOrganizationalUnitEvent> removeOrganizationalUnitEvent;
    @Inject
    private Event<RepoAddedToOrganizationalUnitEvent> repoAddedToOrgUnitEvent;
    @Inject
    private Event<RepoRemovedFromOrganizationalUnitEvent> repoRemovedFromOrgUnitEvent;
    @Inject
    private Event<UpdatedOrganizationalUnitEvent> updatedOrganizationalUnitEvent;
    private Map<String, OrganizationalUnit> registeredOrganizationalUnits = new HashMap<String, OrganizationalUnit>();
    @Inject
    private SessionInfo sessionInfo;

    @PostConstruct
    public void loadOrganizationalUnits() {
        List groups = this.configurationService.getConfiguration(ConfigType.ORGANIZATIONAL_UNIT);
        if (groups != null) {
            for (ConfigGroup groupConfig : groups) {
                String ouName = groupConfig.getName();
                String defaultGroupId = groupConfig.getConfigItemValue("defaultGroupId");
                if (defaultGroupId == null || defaultGroupId.trim().isEmpty()) {
                    groupConfig.setConfigItem(this.configurationFactory.newConfigItem("defaultGroupId", this.getSanitizedDefaultGroupId(ouName)));
                    this.configurationService.updateConfiguration(groupConfig);
                }
                OrganizationalUnit ou = this.organizationalUnitFactory.newOrganizationalUnit(groupConfig);
                this.registeredOrganizationalUnits.put(ou.getName(), ou);
            }
        }
    }

    public OrganizationalUnit getOrganizationalUnit(String name) {
        return this.registeredOrganizationalUnits.get(name);
    }

    public Collection<OrganizationalUnit> getOrganizationalUnits() {
        return new ArrayList<OrganizationalUnit>(this.registeredOrganizationalUnits.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrganizationalUnit createOrganizationalUnit(String name, String owner, String defaultGroupId) {
        OrganizationalUnit organizationalUnit;
        OrganizationalUnit newOrganizationalUnit = null;
        try {
            this.configurationService.startBatch();
            ConfigGroup groupConfig = this.configurationFactory.newConfigGroup(ConfigType.ORGANIZATIONAL_UNIT, name, "");
            groupConfig.addConfigItem(this.configurationFactory.newConfigItem("owner", owner));
            String _defaultGroupId = defaultGroupId == null || defaultGroupId.trim().isEmpty() ? this.getSanitizedDefaultGroupId(name) : defaultGroupId;
            groupConfig.addConfigItem(this.configurationFactory.newConfigItem("defaultGroupId", _defaultGroupId));
            groupConfig.addConfigItem(this.configurationFactory.newConfigItem("repositories", new ArrayList()));
            groupConfig.addConfigItem(this.configurationFactory.newConfigItem("security:groups", new ArrayList()));
            this.configurationService.addConfiguration(groupConfig);
            newOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(groupConfig);
            this.registeredOrganizationalUnits.put(newOrganizationalUnit.getName(), newOrganizationalUnit);
            organizationalUnit = newOrganizationalUnit;
        }
        catch (Throwable throwable) {
            this.configurationService.endBatch();
            if (newOrganizationalUnit != null) {
                this.newOrganizationalUnitEvent.fire((Object)new NewOrganizationalUnitEvent(newOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
            }
            throw throwable;
        }
        this.configurationService.endBatch();
        if (newOrganizationalUnit != null) {
            this.newOrganizationalUnitEvent.fire((Object)new NewOrganizationalUnitEvent(newOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
        }
        return organizationalUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrganizationalUnit createOrganizationalUnit(String name, String owner, String defaultGroupId, Collection<Repository> repositories) {
        OrganizationalUnit organizationalUnit;
        OrganizationalUnit newOrganizationalUnit = null;
        try {
            this.configurationService.startBatch();
            ConfigGroup groupConfig = this.configurationFactory.newConfigGroup(ConfigType.ORGANIZATIONAL_UNIT, name, "");
            groupConfig.addConfigItem(this.configurationFactory.newConfigItem("owner", owner));
            String _defaultGroupId = defaultGroupId == null || defaultGroupId.trim().isEmpty() ? this.getSanitizedDefaultGroupId(name) : defaultGroupId;
            groupConfig.addConfigItem(this.configurationFactory.newConfigItem("defaultGroupId", _defaultGroupId));
            groupConfig.addConfigItem(this.configurationFactory.newConfigItem("repositories", this.getRepositoryAliases(repositories)));
            groupConfig.addConfigItem(this.configurationFactory.newConfigItem("security:groups", new ArrayList()));
            this.configurationService.addConfiguration(groupConfig);
            newOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(groupConfig);
            this.registeredOrganizationalUnits.put(newOrganizationalUnit.getName(), newOrganizationalUnit);
            organizationalUnit = newOrganizationalUnit;
        }
        catch (Throwable throwable) {
            this.configurationService.endBatch();
            if (newOrganizationalUnit != null) {
                this.newOrganizationalUnitEvent.fire((Object)new NewOrganizationalUnitEvent(newOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
            }
            throw throwable;
        }
        this.configurationService.endBatch();
        if (newOrganizationalUnit != null) {
            this.newOrganizationalUnitEvent.fire((Object)new NewOrganizationalUnitEvent(newOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
        }
        return organizationalUnit;
    }

    private List<String> getRepositoryAliases(Collection<Repository> repositories) {
        ArrayList<String> repositoryList = new ArrayList<String>();
        for (Repository repo : repositories) {
            repositoryList.add(repo.getAlias());
        }
        return repositoryList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrganizationalUnit updateOrganizationalUnit(String name, String owner, String defaultGroupId) {
        ConfigGroup thisGroupConfig = this.findGroupConfig(name);
        if (thisGroupConfig != null) {
            OrganizationalUnit organizationalUnit;
            OrganizationalUnit updatedOrganizationalUnit = null;
            try {
                this.configurationService.startBatch();
                thisGroupConfig.setConfigItem(this.configurationFactory.newConfigItem("owner", owner));
                String _defaultGroupId = defaultGroupId == null || defaultGroupId.trim().isEmpty() ? thisGroupConfig.getConfigItemValue("defaultGroupId") : defaultGroupId;
                thisGroupConfig.setConfigItem(this.configurationFactory.newConfigItem("defaultGroupId", _defaultGroupId));
                this.configurationService.updateConfiguration(thisGroupConfig);
                updatedOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(thisGroupConfig);
                this.registeredOrganizationalUnits.put(updatedOrganizationalUnit.getName(), updatedOrganizationalUnit);
                organizationalUnit = updatedOrganizationalUnit;
            }
            catch (Throwable throwable) {
                this.configurationService.endBatch();
                if (updatedOrganizationalUnit != null) {
                    this.updatedOrganizationalUnitEvent.fire((Object)new UpdatedOrganizationalUnitEvent(updatedOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
                }
                throw throwable;
            }
            this.configurationService.endBatch();
            if (updatedOrganizationalUnit != null) {
                this.updatedOrganizationalUnitEvent.fire((Object)new UpdatedOrganizationalUnitEvent(updatedOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
            }
            return organizationalUnit;
        }
        throw new IllegalArgumentException("OrganizationalUnit " + name + " not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepository(OrganizationalUnit organizationalUnit, Repository repository) {
        ConfigGroup thisGroupConfig = this.findGroupConfig(organizationalUnit.getName());
        if (thisGroupConfig != null) {
            try {
                this.configurationService.startBatch();
                ConfigItem repositories = thisGroupConfig.getConfigItem("repositories");
                ((List)repositories.getValue()).add(repository.getAlias());
                this.configurationService.updateConfiguration(thisGroupConfig);
                OrganizationalUnit updatedOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(thisGroupConfig);
                this.registeredOrganizationalUnits.put(updatedOrganizationalUnit.getName(), updatedOrganizationalUnit);
            }
            finally {
                this.configurationService.endBatch();
                this.repoAddedToOrgUnitEvent.fire((Object)new RepoAddedToOrganizationalUnitEvent(organizationalUnit, repository, this.getUserInfo(this.sessionInfo)));
            }
        } else {
            throw new IllegalArgumentException("OrganizationalUnit " + organizationalUnit.getName() + " not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepository(OrganizationalUnit organizationalUnit, Repository repository) {
        ConfigGroup thisGroupConfig = this.findGroupConfig(organizationalUnit.getName());
        if (thisGroupConfig != null) {
            try {
                this.configurationService.startBatch();
                ConfigItem repositories = thisGroupConfig.getConfigItem("repositories");
                ((List)repositories.getValue()).remove(repository.getAlias());
                this.configurationService.updateConfiguration(thisGroupConfig);
                OrganizationalUnit updatedOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(thisGroupConfig);
                this.registeredOrganizationalUnits.put(updatedOrganizationalUnit.getName(), updatedOrganizationalUnit);
            }
            finally {
                this.configurationService.endBatch();
                this.repoRemovedFromOrgUnitEvent.fire((Object)new RepoRemovedFromOrganizationalUnitEvent(organizationalUnit, repository, this.getUserInfo(this.sessionInfo)));
            }
        } else {
            throw new IllegalArgumentException("OrganizationalUnit " + organizationalUnit.getName() + " not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroup(OrganizationalUnit organizationalUnit, String group) {
        block5: {
            block4: {
                ConfigGroup thisGroupConfig = this.findGroupConfig(organizationalUnit.getName());
                if (thisGroupConfig == null) break block4;
                OrganizationalUnit updatedOrganizationalUnit = null;
                try {
                    this.configurationService.startBatch();
                    ConfigItem groups = this.backward.compat(thisGroupConfig).getConfigItem("security:groups");
                    ((List)groups.getValue()).add(group);
                    this.configurationService.updateConfiguration(thisGroupConfig);
                    updatedOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(thisGroupConfig);
                    this.registeredOrganizationalUnits.put(updatedOrganizationalUnit.getName(), updatedOrganizationalUnit);
                }
                catch (Throwable throwable) {
                    this.configurationService.endBatch();
                    if (updatedOrganizationalUnit != null) {
                        this.updatedOrganizationalUnitEvent.fire((Object)new UpdatedOrganizationalUnitEvent(updatedOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
                    }
                    throw throwable;
                }
                this.configurationService.endBatch();
                if (updatedOrganizationalUnit != null) {
                    this.updatedOrganizationalUnitEvent.fire((Object)new UpdatedOrganizationalUnitEvent(updatedOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
                }
                break block5;
            }
            throw new IllegalArgumentException("OrganizationalUnit " + organizationalUnit.getName() + " not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(OrganizationalUnit organizationalUnit, String group) {
        block5: {
            block4: {
                ConfigGroup thisGroupConfig = this.findGroupConfig(organizationalUnit.getName());
                if (thisGroupConfig == null) break block4;
                OrganizationalUnit updatedOrganizationalUnit = null;
                try {
                    this.configurationService.startBatch();
                    ConfigItem groups = this.backward.compat(thisGroupConfig).getConfigItem("security:groups");
                    ((List)groups.getValue()).remove(group);
                    this.configurationService.updateConfiguration(thisGroupConfig);
                    updatedOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(thisGroupConfig);
                    this.registeredOrganizationalUnits.put(updatedOrganizationalUnit.getName(), updatedOrganizationalUnit);
                }
                catch (Throwable throwable) {
                    this.configurationService.endBatch();
                    if (updatedOrganizationalUnit != null) {
                        this.updatedOrganizationalUnitEvent.fire((Object)new UpdatedOrganizationalUnitEvent(updatedOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
                    }
                    throw throwable;
                }
                this.configurationService.endBatch();
                if (updatedOrganizationalUnit != null) {
                    this.updatedOrganizationalUnitEvent.fire((Object)new UpdatedOrganizationalUnitEvent(updatedOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
                }
                break block5;
            }
            throw new IllegalArgumentException("OrganizationalUnit " + organizationalUnit.getName() + " not found");
        }
    }

    protected ConfigGroup findGroupConfig(String name) {
        List groups = this.configurationService.getConfiguration(ConfigType.ORGANIZATIONAL_UNIT);
        if (groups != null) {
            for (ConfigGroup groupConfig : groups) {
                if (!groupConfig.getName().equals(name)) continue;
                return groupConfig;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOrganizationalUnit(String groupName) {
        ConfigGroup thisGroupConfig = this.findGroupConfig(groupName);
        if (thisGroupConfig != null) {
            OrganizationalUnit ou = null;
            try {
                this.configurationService.startBatch();
                this.configurationService.removeConfiguration(thisGroupConfig);
                ou = this.registeredOrganizationalUnits.remove(groupName);
            }
            finally {
                this.configurationService.endBatch();
                if (ou != null) {
                    this.removeOrganizationalUnitEvent.fire((Object)new RemoveOrganizationalUnitEvent(ou, this.getUserInfo(this.sessionInfo)));
                }
            }
        }
    }

    public OrganizationalUnit getParentOrganizationalUnit(Repository repository) {
        for (OrganizationalUnit organizationalUnit : this.registeredOrganizationalUnits.values()) {
            if (organizationalUnit.getRepositories() == null || !organizationalUnit.getRepositories().contains(repository)) continue;
            return organizationalUnit;
        }
        return null;
    }

    public String getSanitizedDefaultGroupId(String proposedGroupId) {
        return proposedGroupId != null ? proposedGroupId.replaceAll("[^A-Za-z0-9_\\-.]", "") : proposedGroupId;
    }

    public Boolean isValidGroupId(String proposedGroupId) {
        if (proposedGroupId != null && !proposedGroupId.trim().isEmpty() && proposedGroupId.length() == this.getSanitizedDefaultGroupId(proposedGroupId).length()) {
            return true;
        }
        return false;
    }

    public void updateRegisteredOU(@Observes @OrgUnit SystemRepositoryChangedEvent changedEvent) {
        this.registeredOrganizationalUnits.clear();
        this.loadOrganizationalUnits();
    }

    public void updateRegisteredOUonRepoChange(@Observes RepositoryEnvironmentUpdatedEvent changedEvent) {
        this.registeredOrganizationalUnits.clear();
        this.loadOrganizationalUnits();
    }

    protected String getUserInfo(SessionInfo sessionInfo) {
        try {
            return sessionInfo.getIdentity().getIdentifier();
        }
        catch (Exception e) {
            return "system";
        }
    }
}

