/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories.git;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.guvnor.structure.repositories.PublicURI;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.impl.DefaultPublicURI;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.PasswordService;
import org.guvnor.structure.server.config.SecureConfigItem;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.Path;

public class GitRepositoryBuilder {
    private final IOService ioService;
    private final PasswordService secureService;
    private GitRepository repo;

    public GitRepositoryBuilder(IOService ioService, PasswordService secureService) {
        this.ioService = ioService;
        this.secureService = secureService;
    }

    public Repository build(ConfigGroup repoConfig) {
        this.repo = new GitRepository(repoConfig.getName());
        if (!this.repo.isValid()) {
            throw new IllegalStateException("Repository " + repoConfig.getName() + " not valid");
        }
        this.addEnvironmentParameters(repoConfig.getItems());
        FileSystem fileSystem = this.createFileSystem(this.repo);
        this.setBranches(fileSystem);
        this.setPublicURIs(fileSystem);
        return this.repo;
    }

    private void setPublicURIs(FileSystem fileSystem) {
        String[] uris = fileSystem.toString().split("\\r?\\n");
        ArrayList<PublicURI> publicURIs = new ArrayList<PublicURI>(uris.length);
        for (String s : uris) {
            int protocolStart = s.indexOf("://");
            publicURIs.add(this.getPublicURI(s, protocolStart));
        }
        this.repo.setPublicURIs(publicURIs);
    }

    private PublicURI getPublicURI(String s, int protocolStart) {
        if (protocolStart > 0) {
            return new DefaultPublicURI(s.substring(0, protocolStart), s);
        }
        return new DefaultPublicURI(s);
    }

    private void setBranches(FileSystem fileSystem) {
        Map<String, org.uberfire.backend.vfs.Path> branches = this.getBranches(fileSystem);
        this.repo.setBranches(branches);
        this.repo.setRoot(this.getDefaultRoot(fileSystem, branches));
    }

    private void addEnvironmentParameters(Collection<ConfigItem> items) {
        for (ConfigItem item : items) {
            if (item instanceof SecureConfigItem) {
                this.repo.addEnvironmentParameter(item.getName(), (Object)this.secureService.decrypt(item.getValue().toString()));
                continue;
            }
            this.repo.addEnvironmentParameter(item.getName(), item.getValue());
        }
    }

    private org.uberfire.backend.vfs.Path getDefaultRoot(FileSystem fileSystem, Map<String, org.uberfire.backend.vfs.Path> branches) {
        org.uberfire.backend.vfs.Path defaultRoot = branches.containsKey("master") ? branches.get("master") : Paths.convert((Path)((Path)fileSystem.getRootDirectories().iterator().next()));
        return defaultRoot;
    }

    private FileSystem createFileSystem(final GitRepository repo) {
        FileSystem fs = null;
        URI uri = null;
        try {
            uri = URI.create(repo.getUri());
            fs = this.ioService.newFileSystem(uri, (Map)new HashMap<String, Object>(repo.getEnvironment()){
                {
                    super(x0);
                    if (!repo.getEnvironment().containsKey("origin")) {
                        this.put("init", true);
                    }
                }
            });
        }
        catch (FileSystemAlreadyExistsException e) {
            fs = this.ioService.getFileSystem(uri);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex.getCause().getMessage(), ex);
        }
        return fs;
    }

    private Map<String, org.uberfire.backend.vfs.Path> getBranches(FileSystem fs) {
        HashMap<String, org.uberfire.backend.vfs.Path> branches = new HashMap<String, org.uberfire.backend.vfs.Path>();
        for (Path path : fs.getRootDirectories()) {
            String gitBranch = this.getBranchName(path);
            branches.put(gitBranch, Paths.convert((Path)path));
        }
        return branches;
    }

    protected String getBranchName(Path path) {
        URI uri = path.toUri();
        String gitBranch = uri.getAuthority();
        if (gitBranch.indexOf("@") != -1) {
            return gitBranch.split("@")[0];
        }
        return gitBranch;
    }
}

