/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories.git;

import java.net.URI;
import java.util.ArrayList;
import org.guvnor.structure.backend.repositories.git.GitRepositoryFactoryHelper;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

public class GitRepositoryFactoryHelperTest {
    private IOService ioService;
    private GitRepositoryFactoryHelper helper;
    private FileSystem fileSystem;
    private ArrayList<Path> rootDirectories;

    @Before
    public void setUp() throws Exception {
        this.ioService = (IOService)Mockito.mock(IOService.class);
        this.helper = new GitRepositoryFactoryHelper(this.ioService);
        this.fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.ioService.newFileSystem((URI)Matchers.any(URI.class), Matchers.anyMap())).thenReturn((Object)this.fileSystem);
        this.rootDirectories = new ArrayList();
        Mockito.when((Object)this.fileSystem.getRootDirectories()).thenReturn(this.rootDirectories);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoSchemeConfigItem() throws Exception {
        this.helper.newRepository(new ConfigGroup());
    }

    @Test(expected=IllegalStateException.class)
    public void testNotValid() throws Exception {
        this.helper.newRepository(this.getConfigGroup());
    }

    @Test
    public void testBranches() throws Exception {
        this.rootDirectories.add(this.createPath("default://origin@uf-playground"));
        this.rootDirectories.add(this.createPath("default://master@uf-playground"));
        this.rootDirectories.add(this.createPath("default://branch1@uf-playground"));
        ConfigGroup configGroup = this.getConfigGroup();
        configGroup.setName("test");
        Repository repository = this.helper.newRepository(configGroup);
        Assert.assertEquals((long)3L, (long)repository.getBranches().size());
        Assert.assertTrue((boolean)repository.getRoot().toURI().contains("master"));
    }

    private Path createPath(String uri) {
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.toUri()).thenReturn((Object)URI.create(uri));
        Mockito.when((Object)path.getFileSystem()).thenReturn((Object)this.fileSystem);
        return path;
    }

    private ConfigGroup getConfigGroup() {
        ConfigGroup repoConfig = new ConfigGroup();
        ConfigItem configItem = new ConfigItem();
        configItem.setName("scheme");
        repoConfig.addConfigItem(configItem);
        return repoConfig;
    }
}

