/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories.git;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.guvnor.structure.repositories.GitMetadata;
import org.guvnor.structure.repositories.GitMetadataStore;
import org.guvnor.structure.repositories.impl.GitMetadataImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.io.object.ObjectStorage;

public class GitMetadataStoreImpl
implements GitMetadataStore {
    private Logger logger = LoggerFactory.getLogger(GitMetadataStoreImpl.class);
    public static final String SEPARATOR = "/";
    public static final String METADATA = "default://system/metadata";
    private ObjectStorage storage;

    @Inject
    public GitMetadataStoreImpl(ObjectStorage storage) {
        this.storage = storage;
    }

    @PostConstruct
    public void init() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Initializing GitMetadataStoreImpl {}", (Object)METADATA);
        }
        this.storage.init(METADATA);
    }

    public void write(String name) {
        this.write(name, "");
    }

    public void write(String name, String origin) {
        GitMetadataImpl repositoryMetadata = (GitMetadataImpl)this.read(name).orElse((GitMetadata)new GitMetadataImpl(name));
        this.removeForkFromOrigin((GitMetadata)repositoryMetadata);
        GitMetadataImpl newRepositoryMetadata = new GitMetadataImpl(name, repositoryMetadata.getForks());
        if (this.isStorableOrigin(origin)) {
            newRepositoryMetadata = new GitMetadataImpl(name, origin, repositoryMetadata.getForks());
            GitMetadataImpl originMetadata = (GitMetadataImpl)this.read(origin).orElse((GitMetadata)new GitMetadataImpl(origin));
            List forks = originMetadata.getForks();
            forks.add(name);
            this.write(origin, (GitMetadata)new GitMetadataImpl(origin, originMetadata.getOrigin(), forks));
        }
        this.write(name, (GitMetadata)newRepositoryMetadata);
    }

    public void write(String name, GitMetadata metadata) {
        this.storage.write(this.buildPath(name), (Object)metadata);
    }

    public Optional<GitMetadata> read(String name) {
        try {
            GitMetadataImpl metadata = (GitMetadataImpl)this.storage.read(this.buildPath(name));
            return Optional.ofNullable(metadata);
        }
        catch (RuntimeException e) {
            return Optional.empty();
        }
    }

    public void delete(String name) {
        String path = this.buildPath(name);
        Optional<GitMetadata> optionalMetadata = this.read(name);
        optionalMetadata.ifPresent(metadata -> {
            this.removeForkFromOrigin((GitMetadata)metadata);
            this.removeOriginFromForks((GitMetadata)metadata);
            this.storage.delete(path);
        });
    }

    private void removeOriginFromForks(GitMetadata metadata) {
        List<GitMetadata> forks = this.getForks(metadata);
        forks.forEach(fork -> {
            GitMetadataImpl newForkImpl = new GitMetadataImpl(fork.getName(), fork.getForks());
            this.storage.write(this.buildPath(fork.getName()), (Object)newForkImpl);
        });
    }

    private void removeForkFromOrigin(GitMetadata metadata) {
        this.getOrigin(metadata).ifPresent(origin -> {
            if (origin.getForks().contains(metadata.getName())) {
                List forks = origin.getForks();
                forks.remove(metadata.getName());
                GitMetadataImpl newOrigin = new GitMetadataImpl(origin.getName(), origin.getOrigin(), forks);
                this.storage.write(this.buildPath(origin.getName()), (Object)newOrigin);
            }
        });
    }

    private Optional<GitMetadata> getOrigin(GitMetadata metadata) {
        return this.read(metadata.getOrigin());
    }

    private List<GitMetadata> getForks(GitMetadata metadata) {
        return metadata.getForks().stream().map(path -> this.read((String)path).get()).collect(Collectors.toList());
    }

    private boolean isStorableOrigin(String origin) {
        return origin != null && origin.matches("(^\\w+\\/\\w+$)");
    }

    private String buildPath(String name) {
        String path = SEPARATOR + name;
        if (name.indexOf(SEPARATOR) == 0) {
            path = name;
        }
        if (path.lastIndexOf(SEPARATOR) == path.length() - 1) {
            path = path.substring(0, path.length());
        }
        return path + ".metadata";
    }
}

