/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.Arrays;
import java.util.Collection;
import org.guvnor.structure.backend.repositories.RepositorySearchServiceImpl;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RepositorySearchServiceTest {
    @Mock
    RepositoryService resourceService;
    @Mock
    Repository itemA;
    @Mock
    Repository itemB;
    private RepositorySearchServiceImpl searchService;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.itemA.getIdentifier()).thenReturn((Object)"itemA");
        Mockito.when((Object)this.itemB.getIdentifier()).thenReturn((Object)"itemB");
        Mockito.when((Object)this.itemA.getAlias()).thenReturn((Object)"Item A");
        Mockito.when((Object)this.itemB.getAlias()).thenReturn((Object)"Item B");
        Mockito.when((Object)this.resourceService.getAllRepositories()).thenReturn(Arrays.asList(this.itemA, this.itemB));
        this.searchService = new RepositorySearchServiceImpl(this.resourceService);
    }

    @Test
    public void testSearchById() throws Exception {
        Collection result = this.searchService.searchById(Arrays.asList("itemA"));
        Assert.assertEquals((long)result.size(), (long)1L);
        Assert.assertEquals((Object)((Repository)result.iterator().next()).getAlias(), (Object)"Item A");
    }

    @Test
    public void testSearchByAlias() throws Exception {
        Collection result = this.searchService.searchByAlias("Item", 10, true);
        Assert.assertEquals((long)result.size(), (long)2L);
    }

    @Test
    public void testSearchCaseSensitiveEmpty() throws Exception {
        Collection result = this.searchService.searchByAlias("item", 10, true);
        Assert.assertEquals((long)result.size(), (long)0L);
    }

    @Test
    public void testSearchCaseUnsensitive() throws Exception {
        Collection result = this.searchService.searchByAlias("item", 10, false);
        Assert.assertEquals((long)result.size(), (long)2L);
    }

    @Test
    public void testSearchMaxItems() throws Exception {
        Collection result = this.searchService.searchByAlias("item", 1, false);
        Assert.assertEquals((long)result.size(), (long)1L);
    }
}

