/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.backcompat;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.backend.config.ConfigurationFactoryImpl;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.junit.Assert;
import org.junit.Test;

public class BackwardCompatibleUtilTest {
    @Test
    public void backwardCompatibilityNullTest() {
        ConfigurationFactoryImpl factory = new ConfigurationFactoryImpl();
        BackwardCompatibleUtil backwardUtil = new BackwardCompatibleUtil((ConfigurationFactory)factory);
        Assert.assertNull((Object)backwardUtil.compat(null));
    }

    @Test
    public void backwardCompatibilityNullSecurityRolesTest() {
        ConfigurationFactoryImpl factory = new ConfigurationFactoryImpl();
        BackwardCompatibleUtil backwardUtil = new BackwardCompatibleUtil((ConfigurationFactory)factory);
        ConfigGroup group = factory.newConfigGroup(ConfigType.PROJECT, "cool", "test");
        Assert.assertNotNull((Object)backwardUtil.compat(group));
        Assert.assertNotNull((Object)backwardUtil.compat(group).getConfigItem("security:groups"));
    }

    @Test
    public void backwardCompatibilityExistingSecurityRolesTest() {
        ConfigurationFactoryImpl factory = new ConfigurationFactoryImpl();
        BackwardCompatibleUtil backwardUtil = new BackwardCompatibleUtil((ConfigurationFactory)factory);
        ConfigGroup group = factory.newConfigGroup(ConfigType.PROJECT, "cool2", "test2");
        group.addConfigItem(factory.newConfigItem("security:roles", (List)new ArrayList(){
            {
                this.add("group1");
            }
        }));
        Assert.assertNotNull((Object)backwardUtil.compat(group).getConfigItem("security:groups"));
        Assert.assertEquals((long)1L, (long)((List)backwardUtil.compat(group).getConfigItem("security:groups").getValue()).size());
        Assert.assertNull((Object)backwardUtil.compat(group).getConfigItem("security:roles"));
    }

    @Test
    public void backwardCompatibilityEmptySecurityRolesTest() {
        ConfigurationFactoryImpl factory = new ConfigurationFactoryImpl();
        BackwardCompatibleUtil backwardUtil = new BackwardCompatibleUtil((ConfigurationFactory)factory);
        ConfigGroup group = factory.newConfigGroup(ConfigType.PROJECT, "cool3", "test3");
        group.addConfigItem(factory.newConfigItem("security:roles", new ArrayList()));
        Assert.assertNotNull((Object)backwardUtil.compat(group).getConfigItem("security:groups"));
        Assert.assertEquals((long)0L, (long)((List)backwardUtil.compat(group).getConfigItem("security:groups").getValue()).size());
        Assert.assertNull((Object)backwardUtil.compat(group).getConfigItem("security:roles"));
    }
}

