/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.test;

import java.lang.annotation.Annotation;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeldJUnitRunner
extends BlockJUnit4ClassRunner {
    private static final Logger logger = LoggerFactory.getLogger(WeldJUnitRunner.class);
    private final Class<?> testClass;
    private Weld weld;
    private WeldContainer weldContainer;

    public WeldJUnitRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        this.testClass = testClass;
    }

    protected Object createTest() throws Exception {
        return this.weldContainer.instance().select(this.testClass, new Annotation[0]).get();
    }

    public void runChild(FrameworkMethod method, RunNotifier notifier) {
        this.startWeld();
        try {
            super.runChild(method, notifier);
        }
        finally {
            this.stopWeld();
        }
    }

    private void startWeld() {
        logger.debug("Starting Weld for test class " + this.testClass.getCanonicalName());
        this.weld = new Weld(this.testClass.getCanonicalName());
        this.weldContainer = this.weld.initialize();
    }

    private void stopWeld() {
        logger.debug("Stopping Weld for test class " + this.testClass.getCanonicalName());
        if (this.weld != null) {
            this.weld.shutdown();
        }
    }
}

