/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.server;

import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.AbstractProjectService;
import org.guvnor.common.services.project.backend.server.ResourceResolver;
import org.guvnor.common.services.project.backend.server.utils.IdentifierUtils;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.guvnor.common.services.project.events.NewPackageEvent;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.events.RenameProjectEvent;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.server.MavenResourceResolver;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.authz.AuthorizationManager;

@Service
@ApplicationScoped
public class MavenProjectServiceImpl
extends AbstractProjectService<Project>
implements ProjectService<Project> {
    public MavenProjectServiceImpl() {
    }

    @Inject
    public MavenProjectServiceImpl(@Named(value="ioStrategy") IOService ioService, POMService pomService, ConfigurationService configurationService, ConfigurationFactory configurationFactory, Event<NewProjectEvent> newProjectEvent, Event<NewPackageEvent> newPackageEvent, Event<RenameProjectEvent> renameProjectEvent, Event<InvalidateDMOProjectCacheEvent> invalidateDMOCache, SessionInfo sessionInfo, AuthorizationManager authorizationManager, BackwardCompatibleUtil backward, CommentedOptionFactory commentedOptionFactory, MavenResourceResolver resourceResolver) {
        super(ioService, pomService, configurationService, configurationFactory, newProjectEvent, newPackageEvent, renameProjectEvent, invalidateDMOCache, sessionInfo, authorizationManager, backward, commentedOptionFactory, (ResourceResolver)resourceResolver);
    }

    public Project newProject(Repository repository, POM pom, String baseUrl) {
        FileSystem fs = Paths.convert((org.uberfire.backend.vfs.Path)repository.getRoot()).getFileSystem();
        try {
            org.uberfire.backend.vfs.Path fsRoot = repository.getRoot();
            org.uberfire.backend.vfs.Path projectRootPath = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)fsRoot).resolve(pom.getName()));
            this.ioService.startBatch(new FileSystem[]{fs}, new Option[]{this.commentedOptionFactory.makeCommentedOption("New project [" + pom.getName() + "]")});
            this.pomService.create(projectRootPath, baseUrl, pom);
            Project project = this.resolveProject(projectRootPath);
            this.newProjectEvent.fire((Object)new NewProjectEvent(project, this.commentedOptionFactory.getSafeSessionId(), this.commentedOptionFactory.getSafeIdentityName()));
            Object[] legalJavaGroupId = IdentifierUtils.convertMavenIdentifierToJavaIdentifier((String[])pom.getGav().getGroupId().split("\\.", -1));
            Object[] legalJavaArtifactId = IdentifierUtils.convertMavenIdentifierToJavaIdentifier((String[])pom.getGav().getArtifactId().split("\\.", -1));
            String defaultWorkspacePath = StringUtils.join((Object[])legalJavaGroupId, (String)"/") + "/" + StringUtils.join((Object[])legalJavaArtifactId, (String)"/");
            org.uberfire.backend.vfs.Path defaultPackagePath = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)projectRootPath).resolve("src/main/resources"));
            Package defaultPackage = this.resolvePackage(defaultPackagePath);
            Package defaultWorkspacePackage = this.resourceResolver.newPackage(defaultPackage, defaultWorkspacePath, false);
            this.newPackageEvent.fire((Object)new NewPackageEvent(defaultWorkspacePackage));
            Project project2 = project;
            return project2;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    public Project newProject(Repository repository, POM pom, String baseURL, DeploymentMode mode) {
        return this.newProject(repository, pom, baseURL);
    }

    public Project resolveProject(org.uberfire.backend.vfs.Path resource) {
        return this.resourceResolver.resolveProject(resource);
    }

    public Project resolveParentProject(org.uberfire.backend.vfs.Path resource) {
        return this.resourceResolver.resolveParentProject(resource);
    }

    public Project resolveToParentProject(org.uberfire.backend.vfs.Path resource) {
        return this.resourceResolver.resolveParentProject(resource);
    }

    public Set<Package> resolvePackages(Project project) {
        return this.resourceResolver.resolvePackages(project);
    }

    public Set<Package> resolvePackages(Package pkg) {
        return this.resourceResolver.resolvePackages(pkg);
    }

    public Package resolveDefaultPackage(Project project) {
        return this.resourceResolver.resolveDefaultPackage(project);
    }

    public Package resolveParentPackage(Package pkg) {
        return this.resourceResolver.resolveParentPackage(pkg);
    }

    public boolean isPom(org.uberfire.backend.vfs.Path resource) {
        return this.resourceResolver.isPom(resource);
    }

    public Package resolvePackage(org.uberfire.backend.vfs.Path resource) {
        return this.resourceResolver.resolvePackage(resource);
    }

    public Project simpleProjectInstance(Path nioProjectRootPath) {
        return this.resourceResolver.simpleProjectInstance(nioProjectRootPath);
    }
}

