/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.server;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.maven.cli.MavenCli;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.server.Deployer;
import org.guvnor.server.ProjectVisitor;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.vfs.Path;
import org.uberfire.workbench.events.ResourceChange;

@Service
@ApplicationScoped
public class BuildServiceImpl
implements BuildService {
    @Inject
    private ProjectVisitor projectVisitor;
    @Inject
    private Deployer deployer;

    public BuildResults build(Project project) {
        return new BuildResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildResults buildAndDeploy(Project project) {
        BuildResults buildResults = new BuildResults();
        try {
            this.projectVisitor.visit(project);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(out);
            MavenCli cli = new MavenCli();
            int result = cli.doMain(new String[]{"clean", "install"}, this.projectVisitor.getRootFolder().getAbsolutePath(), printStream, printStream);
            if (result != 0) {
                BuildMessage message = new BuildMessage();
                message.setId(123L);
                message.setText(new String(out.toByteArray()));
                message.setLevel(Level.ERROR);
                buildResults.addBuildMessage(message);
            }
            this.deployer.deploy(this.projectVisitor.getTargetFolder());
        }
        catch (IOException e) {
            buildResults.addBuildMessage(this.reportError(e));
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)this.projectVisitor.getGuvnorTempFolder());
            }
            catch (IOException e) {
                buildResults.addBuildMessage(this.reportError(e));
            }
        }
        return buildResults;
    }

    public BuildResults buildAndDeploy(Project project, DeploymentMode mode) {
        return this.buildAndDeploy(project);
    }

    public BuildResults buildAndDeploy(Project project, boolean suppressHandlers) {
        return new BuildResults();
    }

    public BuildResults buildAndDeploy(Project project, boolean suppressHandlers, DeploymentMode mode) {
        return this.buildAndDeploy(project, suppressHandlers);
    }

    private BuildMessage reportError(IOException e) {
        BuildMessage message = new BuildMessage();
        message.setText(e.getMessage());
        message.setLevel(Level.ERROR);
        return message;
    }

    public boolean isBuilt(Project project) {
        return true;
    }

    public IncrementalBuildResults addPackageResource(Path resource) {
        return new IncrementalBuildResults();
    }

    public IncrementalBuildResults deletePackageResource(Path resource) {
        return new IncrementalBuildResults();
    }

    public IncrementalBuildResults updatePackageResource(Path resource) {
        return new IncrementalBuildResults();
    }

    public IncrementalBuildResults applyBatchResourceChanges(Project project, Map<Path, Collection<ResourceChange>> changes) {
        return new IncrementalBuildResults();
    }
}

