/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.server;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import org.drools.compiler.kproject.xml.PomModel;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.backend.server.ExtendedM2RepoService;
import org.guvnor.m2repo.backend.server.helpers.PomModelResolver;

public class Deployer {
    @Inject
    private ExtendedM2RepoService extendedM2RepoService;

    public void deploy(File targetFolder) throws IOException {
        for (File file : this.getJars(targetFolder)) {
            BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(file));
            fileInputStream.mark(fileInputStream.available());
            PomModel pomModel = PomModelResolver.resolveFromJar((InputStream)fileInputStream);
            fileInputStream.reset();
            this.extendedM2RepoService.deployJar((InputStream)fileInputStream, new GAV(pomModel.getReleaseId().getGroupId(), pomModel.getReleaseId().getArtifactId(), pomModel.getReleaseId().getVersion()));
            fileInputStream.close();
        }
    }

    private File[] getJars(File targetFolder) {
        return targetFolder.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
    }
}

