/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.server;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.model.Project;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class ProjectVisitor {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    private Project project;
    private File rootFolder;
    private String buildRoot;

    public void visit(Project project) throws IOException {
        this.project = project;
        this.buildRoot = System.getProperty("java.io.tmpdir") + File.separatorChar + "guvnor" + File.separatorChar + project.getProjectName();
        Path path = Paths.convert((org.uberfire.backend.vfs.Path)this.project.getRootPath());
        this.makeTempRootDirectory();
        this.makeTempDirectory(path);
        this.rootFolder = this.makeTempDirectory(path);
        this.visitPaths(this.ioService.newDirectoryStream(path));
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public File getGuvnorTempFolder() {
        return new File(System.getProperty("java.io.tmpdir") + File.separatorChar + "guvnor");
    }

    public File getTargetFolder() {
        return new File(this.buildRoot + File.separatorChar + "target");
    }

    private void visitPaths(DirectoryStream<Path> directoryStream) throws IOException {
        for (Path path : directoryStream) {
            if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) {
                this.makeTempDirectory(path);
                this.visitPaths(Files.newDirectoryStream((Path)path));
                continue;
            }
            this.makeTempFile(path);
        }
    }

    private File makeTempDirectory(Path path) {
        return this.makeTempDirectory(this.getFilePath(path));
    }

    private File makeTempDirectory(String filePath) {
        File tempDirectory = new File(filePath);
        if (!tempDirectory.isFile()) {
            tempDirectory.mkdir();
        }
        return tempDirectory;
    }

    private void makeTempRootDirectory() {
        File tempDirectory = new File(this.buildRoot);
        tempDirectory.mkdirs();
    }

    private void makeTempFile(Path path) throws IOException {
        int count;
        int BUFFER = 2048;
        byte[] data = new byte[2048];
        BufferedInputStream origin = new BufferedInputStream(this.ioService.newInputStream(path, new OpenOption[0]), 2048);
        String filePath = this.getFilePath(path);
        File tempFile = new File(filePath);
        tempFile.createNewFile();
        FileOutputStream output = new FileOutputStream(tempFile);
        while ((count = origin.read(data, 0, 2048)) != -1) {
            output.write(data, 0, count);
        }
        origin.close();
        output.close();
    }

    private String getFilePath(Path path) {
        return this.buildRoot + path.toUri().getRawPath();
    }
}

