/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.admin.service.rest.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.config.CollectorConfiguration;
import org.hawkular.btm.api.services.AdminService;
import org.hawkular.btm.api.services.ConfigurationLoader;

public class AdminServiceRESTClient
implements AdminService {
    private static final Logger log = Logger.getLogger((String)AdminServiceRESTClient.class.getName());
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String HAWKULAR_PERSONA = "Hawkular-Persona";
    private String username = System.getProperty("hawkular-btm.username");
    private String password = System.getProperty("hawkular-btm.password");
    private String authorization = null;
    private String baseUrl = System.getProperty("hawkular-btm.base-uri");

    public AdminServiceRESTClient() {
        if (this.baseUrl != null && this.baseUrl.length() > 0 && this.baseUrl.charAt(this.baseUrl.length() - 1) != '/') {
            this.baseUrl = this.baseUrl + '/';
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.authorization = null;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.authorization = null;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public CollectorConfiguration getConfiguration(String tenantId, String host, String server) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get business transaction: tenantId=[" + tenantId + "] host=[" + host + "] server=[" + server + "]");
        }
        if (System.getProperty("hawkular-btm.config") != null) {
            return ConfigurationLoader.getConfiguration();
        }
        StringBuilder builder = new StringBuilder().append(this.baseUrl).append("admin/config");
        if (host != null) {
            builder.append("?host=");
            builder.append(host);
        }
        if (server != null) {
            if (host == null) {
                builder.append('?');
            } else {
                builder.append('&');
            }
            builder.append("server=");
            builder.append(server);
        }
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                try {
                    return (CollectorConfiguration)mapper.readValue(resp.toString(), CollectorConfiguration.class);
                }
                catch (Throwable t) {
                    log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get collector configuration: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to send 'get' collector configuration request", (Throwable)e);
        }
        return null;
    }

    protected void addHeaders(HttpURLConnection connection, String tenantId) {
        if (tenantId != null) {
            connection.setRequestProperty(HAWKULAR_PERSONA, tenantId);
        }
        if (this.authorization == null && this.username != null) {
            String authString = this.username + ":" + this.password;
            String encoded = Base64.getEncoder().encodeToString(authString.getBytes());
            this.authorization = "Basic " + encoded;
        }
        if (this.authorization != null) {
            connection.setRequestProperty("Authorization", this.authorization);
        }
    }
}

