/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter.cfg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.byteman.agent.Transformer;
import org.jboss.byteman.agent.adapter.cfg.BBlock;
import org.jboss.byteman.agent.adapter.cfg.CodeLocation;
import org.jboss.byteman.agent.adapter.cfg.FanOut;
import org.jboss.byteman.agent.adapter.cfg.TriggerDetails;
import org.jboss.byteman.agent.adapter.cfg.TryCatchDetails;
import org.jboss.byteman.objectweb.asm.Label;
import org.jboss.byteman.objectweb.asm.Type;
import org.jboss.byteman.rule.type.TypeHelper;

public class CFG {
    public static final Type EXECUTE_EXCEPTION_TYPE = Type.getType(TypeHelper.externalizeType("org.jboss.byteman.rule.exception.ExecuteException"));
    public static final Type EARLY_RETURN_EXCEPTION_TYPE = Type.getType(TypeHelper.externalizeType("org.jboss.byteman.rule.exception.EarlyReturnException"));
    public static final Type THROW_EXCEPTION_TYPE = Type.getType(TypeHelper.externalizeType("org.jboss.byteman.rule.exception.ThrowException"));
    public static final String EXECUTE_EXCEPTION_TYPE_NAME = EXECUTE_EXCEPTION_TYPE.getInternalName();
    public static final String EARLY_RETURN_EXCEPTION_TYPE_NAME = EARLY_RETURN_EXCEPTION_TYPE.getInternalName();
    public static final String THROW_EXCEPTION_TYPE_NAME = THROW_EXCEPTION_TYPE.getInternalName();
    private String methodName;
    private BBlock entry;
    private BBlock current;
    private int nextIdx;
    private Map<Label, BBlock> blocks;
    private Map<Label, CodeLocation> labelLocations;
    private Map<BBlock, FanOut> contains;
    private List<String> names;
    private Map<Label, TriggerDetails> triggerStarts;
    private Map<Label, TriggerDetails> triggerEnds;
    private TriggerDetails latestTrigger;
    private Map<Label, List<TryCatchDetails>> tryCatchStarts;
    private Map<Label, List<TryCatchDetails>> tryCatchEnds;
    private Map<Label, List<TryCatchDetails>> tryCatchHandlers;
    private List<TryCatchDetails> currentTryCatchStarts;
    private Map<Label, List<CodeLocation>> openMonitorEnters;
    private Map<CodeLocation, List<CodeLocation>> monitorPairs;
    private Map<CodeLocation, CodeLocation> inverseMonitorPairs;
    private static final int OVERLAPS = 1;
    private static final int CONTAINS = 2;
    private static final int UNKNOWN = 4;

    public CFG(String methodName, Label start) {
        this.methodName = methodName;
        this.nextIdx = 0;
        this.entry = this.current = new BBlock(this, start, this.nextIdx++);
        this.blocks = new HashMap<Label, BBlock>();
        this.contains = new HashMap<BBlock, FanOut>();
        this.labelLocations = new HashMap<Label, CodeLocation>();
        this.names = new ArrayList<String>();
        this.triggerStarts = new HashMap<Label, TriggerDetails>();
        this.triggerEnds = new HashMap<Label, TriggerDetails>();
        this.latestTrigger = null;
        this.tryCatchStarts = new HashMap<Label, List<TryCatchDetails>>();
        this.tryCatchEnds = new HashMap<Label, List<TryCatchDetails>>();
        this.tryCatchHandlers = new HashMap<Label, List<TryCatchDetails>>();
        this.openMonitorEnters = new HashMap<Label, List<CodeLocation>>();
        this.monitorPairs = new HashMap<CodeLocation, List<CodeLocation>>();
        this.inverseMonitorPairs = new HashMap<CodeLocation, CodeLocation>();
        this.blocks.put(start, this.current);
        this.setLocation(start);
        this.contains.put(this.current, new FanOut(start));
        this.openMonitorEnters.put(start, new LinkedList());
        this.currentTryCatchStarts = new LinkedList<TryCatchDetails>();
    }

    public void add(int instruction) {
        this.current.append(instruction);
    }

    public void add(int instruction, int operand) {
        this.current.append(instruction, operand);
    }

    public void add(int instruction, int operand1, int operand2) {
        this.current.append(instruction, operand1, operand2);
    }

    public void add(int instruction, int[] operands) {
        this.current.append(instruction, operands);
    }

    public void add(int instruction, String name) {
        int idx = this.names.indexOf(name);
        if (idx < 0) {
            idx = this.names.size();
            this.names.add(name);
        }
        this.current.append(instruction, idx);
    }

    public void add(int instruction, String name, int dims) {
        int idx = this.names.indexOf(name);
        if (idx < 0) {
            idx = this.names.size();
            this.names.add(name);
        }
        this.current.append(instruction, idx, dims);
    }

    public void add(int instruction, String name, String desc) {
        int idx2;
        int idx1 = this.names.indexOf(name);
        if (idx1 < 0) {
            idx1 = this.names.size();
            this.names.add(name);
        }
        if ((idx2 = this.names.indexOf(desc)) < 0) {
            idx2 = this.names.size();
            this.names.add(desc);
        }
        this.current.append(instruction, idx1, idx2);
    }

    public void add(int instruction, String owner, String name, String desc) {
        int idx3;
        int idx2;
        int idx1 = this.names.indexOf(owner);
        if (idx1 < 0) {
            idx1 = this.names.size();
            this.names.add(owner);
        }
        if ((idx2 = this.names.indexOf(name)) < 0) {
            idx2 = this.names.size();
            this.names.add(name);
        }
        if ((idx3 = this.names.indexOf(desc)) < 0) {
            idx3 = this.names.size();
            this.names.add(desc);
        }
        this.current.append(instruction, idx1, idx2, idx3);
    }

    public void add(int instruction, String owner, String name, String desc, boolean itf) {
        int idx3;
        int idx2;
        int idx1 = this.names.indexOf(owner);
        if (idx1 < 0) {
            idx1 = this.names.size();
            this.names.add(owner);
        }
        if ((idx2 = this.names.indexOf(name)) < 0) {
            idx2 = this.names.size();
            this.names.add(name);
        }
        if ((idx3 = this.names.indexOf(desc)) < 0) {
            idx3 = this.names.size();
            this.names.add(desc);
        }
        int idx4 = itf ? 1 : 0;
        this.current.append(instruction, idx1, idx2, idx3, idx4);
    }

    public CodeLocation setLocation(Label label) {
        CodeLocation location = this.nextLocation();
        this.labelLocations.put(label, location);
        return location;
    }

    public CodeLocation getLocation(Label label) {
        return this.labelLocations.get(label);
    }

    public boolean hasLocation(Label label) {
        return this.labelLocations.get(label) != null;
    }

    public CodeLocation nextLocation() {
        return new CodeLocation(this.current, this.current.getInstructionCount());
    }

    public BBlock getBlock(Label label) {
        CodeLocation location = this.labelLocations.get(label);
        if (location == null) {
            return null;
        }
        return location.getBlock();
    }

    public FanOut getContains(BBlock block) {
        return this.contains.get(block);
    }

    private void addContains(BBlock block, Label label) {
        FanOut containsFanOut = this.contains.get(block);
        if (containsFanOut == null) {
            containsFanOut = new FanOut(block.getLabel());
            this.contains.put(block, containsFanOut);
        }
        containsFanOut.append(label);
    }

    public List<CodeLocation> getOpenMonitorEnters(Label label) {
        return this.openMonitorEnters.get(label);
    }

    public List<CodeLocation> getOpenMonitorEnters(BBlock block) {
        Label l;
        CodeLocation loc;
        List<CodeLocation> blockMonitorEnters = null;
        Iterator<TryCatchDetails> iterator = block.getHandlerStarts();
        if (iterator.hasNext()) {
            blockMonitorEnters = new LinkedList<CodeLocation>();
            while (iterator.hasNext()) {
                TryCatchDetails details = iterator.next();
                details.addOpenLocations(blockMonitorEnters);
            }
            return blockMonitorEnters;
        }
        FanOut fanOut = this.getContains(block);
        int count = fanOut.getToCount();
        for (int i = 0; i < count && (loc = this.getLocation(l = fanOut.getTo(i))).getInstructionIdx() <= 0; ++i) {
            blockMonitorEnters = this.getOpenMonitorEnters(l);
            if (blockMonitorEnters == null) continue;
            return new LinkedList<CodeLocation>(blockMonitorEnters);
        }
        return new LinkedList<CodeLocation>();
    }

    public Iterator<CodeLocation> getOpenMonitors(TriggerDetails triggerDetails) {
        List<TryCatchDetails> tryCatchDetails = this.tryCatchStartDetails(triggerDetails.getStart());
        return tryCatchDetails.get(0).getOpenEnters();
    }

    void addMonitorPair(CodeLocation enter, CodeLocation exit) {
        List<CodeLocation> paired = this.monitorPairs.get(enter);
        if (paired == null) {
            paired = new LinkedList<CodeLocation>();
            this.monitorPairs.put(enter, paired);
        }
        if (!paired.contains(exit)) {
            paired.add(exit);
            CodeLocation inverse = this.inverseMonitorPairs.put(exit, enter);
        }
    }

    private CodeLocation getPairedExit(CodeLocation enter, BBlock block) {
        List<CodeLocation> paired = this.monitorPairs.get(enter);
        if (paired != null) {
            for (CodeLocation location : paired) {
                if (location.getBlock() != block) continue;
                return location;
            }
        }
        return null;
    }

    public CodeLocation getPairedEnter(CodeLocation exit) {
        return this.inverseMonitorPairs.get(exit);
    }

    public int getSavedMonitorIdx(CodeLocation open) {
        int instruction;
        BBlock block = open.getBlock();
        int instructionIdx = open.getInstructionIdx();
        if (instructionIdx <= 0) {
            System.out.println("getSavedMonitorIdx : unexpected! close pair has invalid index " + instructionIdx + " in method " + this.methodName);
        }
        if ((instruction = block.getInstruction(instructionIdx)) != 194) {
            System.out.println("getSavedMonitorIdx : unexpected! close pair instruction " + instruction + " is not MONITOREXIT in method " + this.methodName);
        }
        if ((instruction = block.getInstruction(--instructionIdx)) == 184) {
            while (instruction != 58 && instructionIdx > 0) {
                instruction = block.getInstruction(--instructionIdx);
            }
        }
        if (instruction != 58) {
            System.out.println("getSavedMonitorIdx : unexpected! close pair preceding instruction " + instruction + " is not ASTORE in method " + this.methodName);
            return -1;
        }
        int varIdx = block.getInstructionArg(instructionIdx, 0);
        if (varIdx < 0) {
            System.out.println("getSavedMonitorIdx : unexpected! close pair preceding ASTORE instruction has invalid index " + varIdx + " in method " + this.methodName);
        }
        return varIdx;
    }

    public boolean inOpenMonitor() {
        List<CodeLocation> currentOpenEnters = this.currentOpenEnters(false);
        return currentOpenEnters.size() > 0;
    }

    private List<CodeLocation> currentOpenEnters(boolean dumpOk) {
        CodeLocation enter;
        Iterator<CodeLocation> entersIter = this.current.getMonitorEnters();
        Iterator<CodeLocation> exitsIter = this.current.getMonitorExits();
        List<CodeLocation> openEnters = this.getOpenMonitorEnters(this.current);
        Iterator<CodeLocation> openEntersIter = openEnters.iterator();
        if (Transformer.isDumpCFGPartial() && dumpOk) {
            List<TryCatchDetails> active = this.current.getActiveTryStarts();
            int openEntersCount = openEnters.size();
            System.out.println("Carry forward");
            System.out.println("  open monitors for " + this.current.getBlockIdx() + " ==> {");
            String sepr = "";
            for (int i = 0; i < openEntersCount; ++i) {
                System.out.print(sepr);
                System.out.print(openEnters.get(i));
                sepr = ", ";
            }
            System.out.println("}");
            int activeTryStartsCount = active.size();
            System.out.print("  active try starts for " + this.current.getBlockIdx() + " ==> {");
            sepr = "";
            for (int i = 0; i < activeTryStartsCount; ++i) {
                TryCatchDetails details = active.get(i);
                CodeLocation start = this.getLocation(details.getStart());
                CodeLocation end = this.getLocation(details.getEnd());
                String type = details.getType();
                System.out.print(sepr);
                System.out.print(type);
                System.out.print('-');
                System.out.print(start);
                if (end != null) {
                    System.out.print(":");
                    System.out.print(end);
                }
                sepr = ", ";
            }
            System.out.println("}");
            int currentTryStartsCount = this.currentTryCatchStarts.size();
            System.out.print("  current try starts for " + this.current.getBlockIdx() + " ==> {");
            sepr = "";
            for (int i = 0; i < currentTryStartsCount; ++i) {
                TryCatchDetails details = this.currentTryCatchStarts.get(i);
                CodeLocation start = this.getLocation(details.getStart());
                CodeLocation end = this.getLocation(details.getEnd());
                System.out.print(sepr);
                System.out.print(start);
                if (end != null) {
                    System.out.print(":");
                    System.out.print(end);
                }
                sepr = ", ";
            }
            System.out.println("}");
        }
        LinkedList<CodeLocation> nonLocalExits = new LinkedList<CodeLocation>();
        while (exitsIter.hasNext()) {
            CodeLocation exit = exitsIter.next();
            enter = this.getPairedEnter(exit);
            if (enter != null && enter.getBlock() == this.current) continue;
            nonLocalExits.add(exit);
        }
        exitsIter = nonLocalExits.iterator();
        while (exitsIter.hasNext() && openEntersIter.hasNext()) {
            CodeLocation exit = exitsIter.next();
            enter = openEntersIter.next();
            this.addMonitorPair(enter, exit);
        }
        if (exitsIter.hasNext()) {
            System.out.println("exits unaccounted for in block B" + this.current.getBlockIdx());
        }
        LinkedList<CodeLocation> newOpenEnters = new LinkedList<CodeLocation>();
        while (entersIter.hasNext()) {
            newOpenEnters.add(entersIter.next());
        }
        if (openEntersIter != null) {
            while (openEntersIter.hasNext()) {
                newOpenEnters.add(openEntersIter.next());
            }
        }
        return newOpenEnters;
    }

    private void carryForward() {
        List<TryCatchDetails> activeTryStarts;
        if (Transformer.isDumpCFGPartial()) {
            int blockIdx = this.current.getBlockIdx();
            if (blockIdx == 0) {
                System.out.println("Intermediate Control Flow Graph for " + this.methodName);
            }
            System.out.println("Carry forward for block " + blockIdx);
        }
        Label label = this.current.getLabel();
        int nOuts = this.current.nOuts();
        ArrayList<TryCatchDetails> active = new ArrayList<TryCatchDetails>(this.currentTryCatchStarts);
        Iterator<TryCatchDetails> ends = this.current.getTryEnds();
        while (ends.hasNext()) {
            TryCatchDetails details = ends.next();
            CodeLocation location = this.getLocation(details.getEnd());
            if (location.getInstructionIdx() <= 0) continue;
            active.add(details);
        }
        this.current.setActiveTryStarts(active);
        if (Transformer.isDumpCFGPartial()) {
            System.out.println(this.current);
        }
        List<CodeLocation> newOpenEnters = this.currentOpenEnters(true);
        int newOpenCount = newOpenEnters.size();
        for (int i = 1; i <= nOuts; ++i) {
            int j;
            label = this.current.nthOut(i);
            List<CodeLocation> blockOpenEnters = this.openMonitorEnters.get(label);
            if (blockOpenEnters == null) {
                this.openMonitorEnters.put(label, newOpenEnters);
                if (!Transformer.isDumpCFGPartial()) continue;
                System.out.print("open monitors " + label + " ==> {");
                String sepr = "";
                for (j = 0; j < newOpenCount; ++j) {
                    CodeLocation l = newOpenEnters.get(j);
                    System.out.print(sepr);
                    System.out.print("BB");
                    System.out.print(l.getBlock().getBlockIdx());
                    System.out.print(".");
                    System.out.print(l.getInstructionIdx());
                    sepr = ", ";
                }
                System.out.println("}");
                continue;
            }
            int openCount = blockOpenEnters.size();
            if (openCount != newOpenCount) {
                System.out.println("CFG.carryForward: unexpected! invalid open enters count for block " + label + " in method " + this.methodName);
            }
            for (j = 0; j < newOpenCount && j < openCount; ++j) {
                CodeLocation l1 = blockOpenEnters.get(j);
                CodeLocation l2 = newOpenEnters.get(j);
                if (l1.getBlock() != l2.getBlock()) {
                    System.out.println("CFG.carryForward: unexpected! invalid open enters block for block " + label + " at index " + j + " in method " + this.methodName);
                }
                if (l1.getInstructionIdx() == l2.getInstructionIdx()) continue;
                System.out.println("CFG.carryForward: unexpected! invalid open enters instruction index for block " + label + " at index " + j + " in method " + this.methodName);
            }
        }
        if (Transformer.isDumpCFGPartial()) {
            System.out.println("propagating locally closed monitors to active handlers");
        }
        if ((activeTryStarts = this.current.getActiveTryStarts()) != null) {
            Iterator<CodeLocation> exitIter = this.current.getMonitorExits();
            while (exitIter.hasNext()) {
                CodeLocation exit = exitIter.next();
                CodeLocation enter = this.getPairedEnter(exit);
                for (TryCatchDetails activeRegion : activeTryStarts) {
                    CodeLocation tryEnd;
                    CodeLocation tryStart;
                    int containment;
                    CodeLocation handlerStart;
                    if (activeRegion.containsOpenEnter(enter) || (handlerStart = this.getLocation(activeRegion.getHandler())) != null || (containment = this.computeContainment(tryStart = this.getLocation(activeRegion.getStart()), tryEnd = this.getLocation(activeRegion.getEnd()), enter, exit, 1)) != 1) continue;
                    if (Transformer.isDumpCFGPartial()) {
                        System.out.println("  try:catch " + tryStart + ":" + tryEnd + " overlaps enter:exit " + enter + ":" + exit);
                    }
                    List<TryCatchDetails> shadowRegions = activeRegion.getShadowRegions();
                    boolean isShadow = false;
                    if (shadowRegions != null) {
                        Iterator<TryCatchDetails> shadowRegionsIter = shadowRegions.iterator();
                        while (shadowRegionsIter.hasNext() && !isShadow) {
                            CodeLocation shadowEnd;
                            TryCatchDetails shadowRegion = shadowRegionsIter.next();
                            CodeLocation shadowStart = this.getLocation(shadowRegion.getStart());
                            containment = this.computeContainment(shadowStart, shadowEnd = this.getLocation(shadowRegion.getEnd()), enter, exit, 2);
                            if (containment != 2) continue;
                            if (Transformer.isDumpCFGPartial()) {
                                System.out.println("  shadow try:catch " + tryStart + ":" + tryEnd + " contains enter:exit " + enter + ":" + exit);
                            }
                            if (Transformer.isDumpCFGPartial()) {
                                System.out.println("  ignoring open enter " + enter + " for region " + tryStart + ":" + (tryEnd != null ? tryEnd.toString() : "??") + " shadowed by region " + shadowStart + ":" + (shadowEnd != null ? shadowEnd.toString() : "??"));
                            }
                            isShadow = true;
                        }
                    }
                    if (isShadow) continue;
                    if (Transformer.isDumpCFGPartial()) {
                        System.out.println("  propagating enter " + enter + " to try handler for " + tryStart + ":" + (tryEnd != null ? tryEnd.toString() : "??"));
                    }
                    activeRegion.addOpenEnter(enter);
                }
            }
            if (Transformer.isDumpCFGPartial()) {
                System.out.println("propagating open monitors to active handlers");
            }
            for (CodeLocation enter : newOpenEnters) {
                for (TryCatchDetails activeRegion : activeTryStarts) {
                    CodeLocation tryEnd;
                    CodeLocation tryStart;
                    int containment;
                    if (activeRegion.containsOpenEnter(enter) || (containment = this.computeContainment(tryStart = this.getLocation(activeRegion.getStart()), tryEnd = this.getLocation(activeRegion.getEnd()), enter, null, 1)) != 1) continue;
                    if (Transformer.isDumpCFGPartial()) {
                        System.out.println(" try:catch " + tryStart + ":" + tryEnd + " overlaps enter:... " + enter + ":...");
                    }
                    List<TryCatchDetails> shadowRegions = activeRegion.getShadowRegions();
                    boolean isShadow = false;
                    if (shadowRegions != null) {
                        Iterator<TryCatchDetails> shadowRegionsIter = shadowRegions.iterator();
                        while (shadowRegionsIter.hasNext() && !isShadow) {
                            CodeLocation shadowEnd;
                            TryCatchDetails shadowRegion = shadowRegionsIter.next();
                            CodeLocation shadowStart = this.getLocation(shadowRegion.getStart());
                            containment = this.computeContainment(shadowStart, shadowEnd = this.getLocation(shadowRegion.getEnd()), enter, null, 2);
                            if (containment == 2) {
                                if (Transformer.isDumpCFGPartial()) {
                                    System.out.println("  shadow try:catch " + tryStart + ":" + tryEnd + " contains enter:... " + enter + ":...");
                                }
                                if (Transformer.isDumpCFGPartial()) {
                                    System.out.println("  ignoring open enter " + enter + " for region " + tryStart + ":" + (tryEnd != null ? tryEnd.toString() : "??") + " shadowed by region " + shadowStart + ":" + (shadowEnd != null ? shadowEnd.toString() : "??"));
                                }
                                isShadow = true;
                                continue;
                            }
                            if (containment != 4) continue;
                            if (Transformer.isDumpCFGPartial()) {
                                System.out.println("  shadow try:catch " + tryStart + ":" + tryEnd + " unknown containment for enter:... " + enter + ":...");
                            }
                            if (Transformer.isDumpCFGPartial()) {
                                System.out.println("ignoring open enter " + enter + " for region " + tryStart + ":" + (tryEnd != null ? tryEnd.toString() : "??") + " potentially shadowed by region " + shadowStart + ":" + (shadowEnd != null ? shadowEnd.toString() : "??"));
                            }
                            isShadow = true;
                        }
                    }
                    if (isShadow) continue;
                    if (Transformer.isDumpCFGPartial()) {
                        System.out.println("propagating enter " + enter + " to try handler for " + tryStart + ":" + (tryEnd != null ? tryEnd.toString() : "??"));
                    }
                    activeRegion.addOpenEnter(enter);
                }
            }
        }
    }

    private int computeContainment(CodeLocation tryStart, CodeLocation tryEnd, CodeLocation enter, CodeLocation exit, int flags) {
        boolean result = false;
        if (tryStart.getBlockIdx() < this.current.getBlockIdx()) {
            tryStart = new CodeLocation(this.current, 0);
        }
        if (enter.getBlockIdx() < this.current.getBlockIdx()) {
            enter = new CodeLocation(this.current, 0);
        }
        if (exit == null) {
            if (tryEnd == null) {
                if ((flags & 2) != 0) {
                    return 4;
                }
                return 1;
            }
            if (tryEnd.compareTo(enter) <= 0) {
                return 0;
            }
            if ((flags & 2) == 0) {
                return 1;
            }
            return 0;
        }
        if (tryEnd == null) {
            if (exit.compareTo(tryStart) < 0) {
                return 0;
            }
            if ((flags & 2) == 0) {
                return 1;
            }
            if (this.tryStartMayContainEnter(tryStart, enter)) {
                return 2;
            }
            return 0;
        }
        if (exit.compareTo(tryStart) < 0 || tryEnd.compareTo(enter) <= 0) {
            return 0;
        }
        if ((flags & 2) == 0) {
            return 1;
        }
        if (exit.compareTo(tryEnd) >= 0) {
            return 0;
        }
        if (this.tryStartMayContainEnter(tryStart, enter)) {
            return 2;
        }
        return 0;
    }

    private boolean tryStartMayContainEnter(CodeLocation tryStart, CodeLocation enter) {
        int enterBlockIdx = enter.getBlockIdx();
        int tryStartBlockIdx = tryStart.getBlockIdx();
        if (tryStartBlockIdx < enterBlockIdx) {
            return true;
        }
        if (tryStartBlockIdx == enterBlockIdx) {
            int enterInsnIdx = enter.getInstructionIdx();
            int tryStartInsnIdx = tryStart.getInstructionIdx();
            if (tryStartInsnIdx <= enterInsnIdx + 1) {
                return true;
            }
        }
        return false;
    }

    public void split(Label newStart) {
        this.current.append(newStart);
        this.carryForward();
        this.current = new BBlock(this, newStart, this.nextIdx++);
        this.blocks.put(newStart, this.current);
    }

    public void split(Label newStart, Label out) {
        this.current.append(newStart);
        this.current.append(out);
        this.carryForward();
        this.current = new BBlock(this, newStart, this.nextIdx++);
        this.blocks.put(newStart, this.current);
    }

    public void split(Label newStart, Label out, Label out2) {
        this.current.append(newStart);
        this.current.append(out);
        this.current.append(out2);
        this.carryForward();
        this.current = new BBlock(this, newStart, this.nextIdx++);
        this.blocks.put(newStart, this.current);
    }

    public void split(Label newStart, Label dflt, Label[] labels) {
        this.current.append(newStart);
        this.current.append(dflt);
        for (int i = 0; i < labels.length; ++i) {
            this.current.append(labels[i]);
        }
        this.carryForward();
        this.current = new BBlock(this, newStart, this.nextIdx++);
        this.blocks.put(newStart, this.current);
    }

    public boolean tryCatchStart(Label label) {
        return this.tryCatchStarts.containsKey(label);
    }

    public boolean tryCatchEnd(Label label) {
        return this.tryCatchEnds.containsKey(label);
    }

    public boolean tryCatchHandlerStart(Label label) {
        return this.tryCatchHandlers.containsKey(label);
    }

    public List<TryCatchDetails> tryCatchStartDetails(Label label) {
        return this.tryCatchStarts.get(label);
    }

    public List<TryCatchDetails> tryCatchEndDetails(Label label) {
        return this.tryCatchEnds.get(label);
    }

    public List<TryCatchDetails> tryCatchHandlerStartDetails(Label label) {
        return this.tryCatchHandlers.get(label);
    }

    public boolean triggerStart(Label label) {
        return this.triggerStarts.containsKey(label);
    }

    public boolean triggerEnd(Label label) {
        return this.triggerEnds.containsKey(label);
    }

    public TriggerDetails triggerStartDetails(Label label) {
        return this.triggerStarts.get(label);
    }

    public TriggerDetails triggerEndDetails(Label label) {
        return this.triggerEnds.get(label);
    }

    public Iterator<TriggerDetails> triggerDetails() {
        return this.triggerStarts.values().iterator();
    }

    public void visitLabel(Label label) {
        List<TryCatchDetails> newhandlers;
        List<TryCatchDetails> newEnds;
        List<TryCatchDetails> newStarts;
        this.addContains(this.current, label);
        CodeLocation location = this.setLocation(label);
        if (Transformer.isDumpCFGPartial()) {
            System.out.println("visitLabel " + label + " " + location);
        }
        if ((newStarts = this.tryCatchStartDetails(label)) != null) {
            this.current.addTryStarts(newStarts);
            this.currentTryCatchStarts.addAll(newStarts);
        }
        if ((newEnds = this.tryCatchEndDetails(label)) != null) {
            this.current.addTryEnds(newEnds);
            this.currentTryCatchStarts.removeAll(newEnds);
        }
        if ((newhandlers = this.tryCatchHandlerStartDetails(label)) != null) {
            this.current.addHandlerStarts(newhandlers);
        }
        if (newStarts != null) {
            for (TryCatchDetails currentStart : this.currentTryCatchStarts) {
                if (newStarts.contains(currentStart)) break;
                for (TryCatchDetails newStart : newStarts) {
                    if (newStart.getType() != null && !newStart.getType().equals(currentStart.getType())) continue;
                    if (Transformer.isDumpCFGPartial()) {
                        System.out.println("" + newStart + " shadows " + currentStart);
                    }
                    currentStart.addShadowRegion(newStart);
                }
            }
            for (TryCatchDetails newStart1 : newStarts) {
                TryCatchDetails ignore;
                Iterator<TryCatchDetails> newStartsIter2 = newStarts.iterator();
                while (newStartsIter2.hasNext() && (ignore = newStartsIter2.next()) != newStart1) {
                }
                while (newStartsIter2.hasNext()) {
                    TryCatchDetails newStart2 = newStartsIter2.next();
                    if (newStart1.getType() != null && !newStart1.getType().equals(newStart2.getType())) continue;
                    if (Transformer.isDumpCFGPartial()) {
                        System.out.println("" + newStart1 + "shadows " + newStart2);
                    }
                    newStart2.addShadowRegion(newStart1);
                }
            }
        }
    }

    public void visitTriggerStart(Label label) {
        this.latestTrigger = new TriggerDetails(this, label);
        this.triggerStarts.put(label, this.latestTrigger);
    }

    public void visitTriggerEnd(Label label) {
        this.latestTrigger.setEnd(label);
        this.triggerEnds.put(label, this.latestTrigger);
        this.latestTrigger = null;
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (Transformer.isDumpCFGPartial()) {
            System.out.println("visitTryCatchBlock " + type + " start: " + start + " end: " + end + " handler: " + handler);
        }
        boolean isTriggerHandler = this.triggerStarts.containsKey(start);
        TryCatchDetails details = new TryCatchDetails(this, start, end, handler, type, isTriggerHandler);
        List<TryCatchDetails> detailsList = this.tryCatchStarts.get(start);
        if (detailsList == null) {
            detailsList = new LinkedList<TryCatchDetails>();
            this.tryCatchStarts.put(start, detailsList);
        }
        detailsList.add(details);
        detailsList = this.tryCatchEnds.get(end);
        if (detailsList == null) {
            detailsList = new LinkedList<TryCatchDetails>();
            this.tryCatchEnds.put(end, detailsList);
        }
        detailsList.add(details);
        detailsList = this.tryCatchHandlers.get(handler);
        if (detailsList == null) {
            detailsList = new LinkedList<TryCatchDetails>();
            this.tryCatchHandlers.put(handler, detailsList);
        }
        detailsList.add(details);
    }

    public boolean inBytemanHandler() {
        Iterator<TryCatchDetails> handlerStarts = this.current.getHandlerStarts();
        while (handlerStarts.hasNext()) {
            TryCatchDetails details = handlerStarts.next();
            if (details.isTriggerHandler()) {
                return true;
            }
            String typeName = details.getType();
            if (typeName == null || !typeName.equals(EARLY_RETURN_EXCEPTION_TYPE_NAME) && !typeName.equals(EXECUTE_EXCEPTION_TYPE_NAME) && !typeName.equals(THROW_EXCEPTION_TYPE_NAME)) continue;
            return true;
        }
        return false;
    }

    public boolean inRethrowHandler() {
        int nextIdx = this.current.getInstructionCount();
        if (nextIdx >= 4 && this.current.getInstruction(nextIdx - 1) == 25 && this.current.getInstruction(nextIdx - 2) == 195 && this.current.getInstruction(nextIdx - 3) == 25 && this.current.getInstruction(nextIdx - 4) == 58 && this.current.getInstructionArg(nextIdx - 1, 0) == this.current.getInstructionArg(nextIdx - 4, 0)) {
            return true;
        }
        return nextIdx >= 2 && this.current.getInstruction(nextIdx - 1) == 195 && this.current.getInstruction(nextIdx - 2) == 25;
    }

    public boolean inBytemanTrigger() {
        if (this.latestTrigger != null) {
            return true;
        }
        for (TryCatchDetails details : this.currentTryCatchStarts) {
            if (details.isTriggerHandler()) {
                return true;
            }
            String typeName = details.getType();
            if (typeName == null || !typeName.equals(EARLY_RETURN_EXCEPTION_TYPE_NAME) && !typeName.equals(EXECUTE_EXCEPTION_TYPE_NAME) && !typeName.equals(THROW_EXCEPTION_TYPE_NAME)) continue;
            return true;
        }
        return false;
    }

    public void visitMaxs() {
    }

    public void visitEnd() {
        if (Transformer.isDumpCFG()) {
            System.out.println(this);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Control Flow Graph for ");
        buf.append(this.methodName);
        buf.append("\n");
        BBlock next = this.entry;
        while (next != null) {
            next.printTo(buf);
            next = this.blocks.get(next.next());
        }
        return buf.toString();
    }

    public int getBlockInstructionIdx(Label label) {
        CodeLocation location = this.labelLocations.get(label);
        if (location == null) {
            return -1;
        }
        return location.getInstructionIdx();
    }

    public String getName(int nameIdx) {
        return this.names.get(nameIdx);
    }
}

