/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.RuleCheckAdapter;
import org.jboss.byteman.agent.adapter.RuleCheckMethodAdapter;
import org.jboss.byteman.objectweb.asm.ClassVisitor;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.type.TypeHelper;

public class FieldAccessCheckAdapter
extends RuleCheckAdapter {
    private String ownerClass;
    private String fieldName;
    private int flags;
    private int count;

    public FieldAccessCheckAdapter(ClassVisitor cv, TransformContext transformContext, String ownerClass, String fieldName, int flags, int count) {
        super(cv, transformContext);
        this.ownerClass = ownerClass;
        this.fieldName = fieldName;
        this.flags = flags;
        this.count = count;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.matchTargetMethod(access, name, desc)) {
            this.setVisited();
            return new FieldAccessCheckMethodAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private class FieldAccessCheckMethodAdapter
    extends RuleCheckMethodAdapter {
        private int access;
        private String name;
        private String descriptor;
        private String signature;
        private String[] exceptions;
        private int visitedCount;

        FieldAccessCheckMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor);
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
            this.signature = signature;
            this.exceptions = exceptions;
            this.visitedCount = 0;
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if ((FieldAccessCheckAdapter.this.count == 0 || this.visitedCount < FieldAccessCheckAdapter.this.count) && this.matchCall(opcode, owner, name, desc)) {
                ++this.visitedCount;
                if (FieldAccessCheckAdapter.this.count == 0 || this.visitedCount == FieldAccessCheckAdapter.this.count) {
                    this.setTriggerPoint();
                }
            }
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        private boolean matchCall(int opcode, String owner, String name, String desc) {
            if (!FieldAccessCheckAdapter.this.fieldName.equals(name)) {
                return false;
            }
            switch (opcode) {
                case 178: 
                case 180: {
                    if ((FieldAccessCheckAdapter.this.flags & 1) != 0) break;
                    return false;
                }
                case 179: 
                case 181: {
                    if ((FieldAccessCheckAdapter.this.flags & 2) != 0) break;
                    return false;
                }
            }
            if (FieldAccessCheckAdapter.this.ownerClass != null && !FieldAccessCheckAdapter.this.ownerClass.equals(TypeHelper.internalizeClass(owner))) {
                if (FieldAccessCheckAdapter.this.ownerClass.indexOf(46) >= 0) {
                    return false;
                }
                int ownerPackageIdx = owner.lastIndexOf(47);
                if (ownerPackageIdx < 0) {
                    return false;
                }
                if (!owner.substring(ownerPackageIdx + 1).equals(FieldAccessCheckAdapter.this.ownerClass)) {
                    return false;
                }
            }
            return true;
        }
    }
}

