/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.shaded.org.mvel2.templates.res;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import org.hawkular.btm.shaded.org.mvel2.MVEL;
import org.hawkular.btm.shaded.org.mvel2.ParserContext;
import org.hawkular.btm.shaded.org.mvel2.integration.VariableResolverFactory;
import org.hawkular.btm.shaded.org.mvel2.templates.CompiledTemplate;
import org.hawkular.btm.shaded.org.mvel2.templates.TemplateCompiler;
import org.hawkular.btm.shaded.org.mvel2.templates.TemplateError;
import org.hawkular.btm.shaded.org.mvel2.templates.TemplateRuntime;
import org.hawkular.btm.shaded.org.mvel2.templates.res.Node;
import org.hawkular.btm.shaded.org.mvel2.templates.util.TemplateOutputStream;
import org.hawkular.btm.shaded.org.mvel2.templates.util.TemplateTools;

public class CompiledIncludeNode
extends Node {
    private Serializable cIncludeExpression;
    private Serializable cPreExpression;
    private long fileDateStamp;
    private CompiledTemplate cFileCache;
    private ParserContext context;

    public CompiledIncludeNode(int begin, String name, char[] template, int start, int end, ParserContext context) {
        this.begin = begin;
        this.name = name;
        this.contents = template;
        this.cStart = start;
        this.cEnd = end - 1;
        this.end = end;
        this.context = context;
        int mark = TemplateTools.captureToEOS(this.contents, this.cStart);
        this.cIncludeExpression = MVEL.compileExpression(this.contents, this.cStart, mark - this.cStart, context);
        if (mark != this.contents.length) {
            this.cPreExpression = MVEL.compileExpression(this.contents, ++mark, this.cEnd - mark, context);
        }
    }

    public Object eval(TemplateRuntime runtime, TemplateOutputStream appender, Object ctx, VariableResolverFactory factory) {
        String file = MVEL.executeExpression((Object)this.cIncludeExpression, ctx, factory, String.class);
        if (this.cPreExpression != null) {
            MVEL.executeExpression((Object)this.cPreExpression, ctx, factory);
        }
        if (this.next != null) {
            return this.next.eval(runtime, appender.append(String.valueOf(TemplateRuntime.eval(this.readFile(runtime, file, ctx, factory), ctx, factory))), ctx, factory);
        }
        return appender.append(String.valueOf(MVEL.eval(this.readFile(runtime, file, ctx, factory), ctx, factory)));
    }

    private String readFile(TemplateRuntime runtime, String fileName, Object ctx, VariableResolverFactory factory) {
        File file = new File(String.valueOf(runtime.getRelPath().peek()) + "/" + fileName);
        if (this.fileDateStamp == 0L || this.fileDateStamp != file.lastModified()) {
            this.fileDateStamp = file.lastModified();
            this.cFileCache = TemplateCompiler.compileTemplate(CompiledIncludeNode.readInFile(runtime, file), this.context);
        }
        return String.valueOf(TemplateRuntime.execute(this.cFileCache, ctx, factory));
    }

    public boolean demarcate(Node terminatingNode, char[] template) {
        return false;
    }

    public static String readInFile(TemplateRuntime runtime, File file) {
        try {
            int read;
            FileInputStream instream = new FileInputStream(file);
            BufferedInputStream bufstream = new BufferedInputStream(instream);
            runtime.getRelPath().push(file.getParent());
            byte[] buf = new byte[10];
            StringBuilder appender = new StringBuilder();
            while ((read = bufstream.read(buf)) != -1) {
                for (int i = 0; i < read; ++i) {
                    appender.append((char)buf[i]);
                }
            }
            bufstream.close();
            instream.close();
            runtime.getRelPath().pop();
            return appender.toString();
        }
        catch (FileNotFoundException e) {
            throw new TemplateError("cannot include template '" + file.getPath() + "': file not found.");
        }
        catch (IOException e) {
            throw new TemplateError("unknown I/O exception while including '" + file.getPath() + "' (stacktrace nested)", e);
        }
    }
}

