/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.RuleMethodAdapter;
import org.jboss.byteman.objectweb.asm.Handle;
import org.jboss.byteman.objectweb.asm.Label;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.objectweb.asm.Opcodes;
import org.jboss.byteman.objectweb.asm.Type;
import org.jboss.byteman.objectweb.asm.commons.Method;
import org.jboss.byteman.objectweb.asm.commons.TableSwitchGenerator;
import org.jboss.byteman.rule.Rule;

public class RuleGeneratorAdapter
extends RuleMethodAdapter {
    private static final String CLDESC = "Ljava/lang/Class;";
    private static final Type BYTE_TYPE = Type.getObjectType("java/lang/Byte");
    private static final Type BOOLEAN_TYPE = Type.getObjectType("java/lang/Boolean");
    private static final Type SHORT_TYPE = Type.getObjectType("java/lang/Short");
    private static final Type CHARACTER_TYPE = Type.getObjectType("java/lang/Character");
    private static final Type INTEGER_TYPE = Type.getObjectType("java/lang/Integer");
    private static final Type FLOAT_TYPE = Type.getObjectType("java/lang/Float");
    private static final Type LONG_TYPE = Type.getObjectType("java/lang/Long");
    private static final Type DOUBLE_TYPE = Type.getObjectType("java/lang/Double");
    private static final Type NUMBER_TYPE = Type.getObjectType("java/lang/Number");
    private static final Type OBJECT_TYPE = Type.getObjectType("java/lang/Object");
    private static final Method BOOLEAN_VALUE = Method.getMethod("boolean booleanValue()");
    private static final Method CHAR_VALUE = Method.getMethod("char charValue()");
    private static final Method INT_VALUE = Method.getMethod("int intValue()");
    private static final Method FLOAT_VALUE = Method.getMethod("float floatValue()");
    private static final Method LONG_VALUE = Method.getMethod("long longValue()");
    private static final Method DOUBLE_VALUE = Method.getMethod("double doubleValue()");
    public static final int ADD = 96;
    public static final int SUB = 100;
    public static final int MUL = 104;
    public static final int DIV = 108;
    public static final int REM = 112;
    public static final int NEG = 116;
    public static final int SHL = 120;
    public static final int SHR = 122;
    public static final int USHR = 124;
    public static final int AND = 126;
    public static final int OR = 128;
    public static final int XOR = 130;
    public static final int EQ = 153;
    public static final int NE = 154;
    public static final int LT = 155;
    public static final int GE = 156;
    public static final int GT = 157;
    public static final int LE = 158;
    private final Type[] argumentTypes;
    private final Type returnType;
    private final List localTypes;
    private int nextLocal;
    private int localHighWater;

    public RuleGeneratorAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String desc, Rule rule) {
        super(mv, transformContext, access, name, desc, rule);
        this.argumentTypes = Type.getArgumentTypes(desc);
        this.returnType = Type.getReturnType(desc);
        this.localTypes = new ArrayList();
        this.initLocalTypes();
    }

    private void initLocalTypes() {
        String name = this.getTriggerClassName().replace('.', '/');
        if ((this.access & 8) == 0) {
            this.localTypes.add(Type.getType("L" + name + ";"));
        }
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            Type argumentType = this.argumentTypes[i];
            int size = argumentType.getSize();
            this.localTypes.add(argumentType);
            if (size <= 1) continue;
            this.localTypes.add(null);
        }
        this.nextLocal = this.localHighWater = this.localTypes.size();
    }

    private static String[] getInternalNames(Type[] types) {
        if (types == null) {
            return null;
        }
        String[] names = new String[types.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = types[i].getInternalName();
        }
        return names;
    }

    public void push(boolean value) {
        this.push(value ? 1 : 0);
    }

    public void push(int value) {
        if (value >= -1 && value <= 5) {
            this.visitInsn(3 + value);
        } else if (value >= -128 && value <= 127) {
            this.visitIntInsn(16, value);
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            this.visitIntInsn(17, value);
        } else {
            this.visitLdcInsn(value);
        }
    }

    public void push(long value) {
        if (value == 0L || value == 1L) {
            this.visitInsn(9 + (int)value);
        } else {
            this.visitLdcInsn(value);
        }
    }

    public void push(float value) {
        int bits = Float.floatToIntBits(value);
        if ((long)bits == 0L || bits == 1065353216 || bits == 0x40000000) {
            this.visitInsn(11 + (int)value);
        } else {
            this.visitLdcInsn(Float.valueOf(value));
        }
    }

    public void push(double value) {
        long bits = Double.doubleToLongBits(value);
        if (bits == 0L || bits == 0x3FF0000000000000L) {
            this.visitInsn(14 + (int)value);
        } else {
            this.visitLdcInsn(value);
        }
    }

    public void push(String value) {
        if (value == null) {
            this.visitInsn(1);
        } else {
            this.visitLdcInsn(value);
        }
    }

    public void push(Type value) {
        if (value == null) {
            this.visitInsn(1);
        } else {
            switch (value.getSort()) {
                case 1: {
                    this.visitFieldInsn(178, "java/lang/Boolean", "TYPE", CLDESC);
                    break;
                }
                case 2: {
                    this.visitFieldInsn(178, "java/lang/Character", "TYPE", CLDESC);
                    break;
                }
                case 3: {
                    this.visitFieldInsn(178, "java/lang/Byte", "TYPE", CLDESC);
                    break;
                }
                case 4: {
                    this.visitFieldInsn(178, "java/lang/Short", "TYPE", CLDESC);
                    break;
                }
                case 5: {
                    this.visitFieldInsn(178, "java/lang/Integer", "TYPE", CLDESC);
                    break;
                }
                case 6: {
                    this.visitFieldInsn(178, "java/lang/Float", "TYPE", CLDESC);
                    break;
                }
                case 7: {
                    this.visitFieldInsn(178, "java/lang/Long", "TYPE", CLDESC);
                    break;
                }
                case 8: {
                    this.visitFieldInsn(178, "java/lang/Double", "TYPE", CLDESC);
                    break;
                }
                default: {
                    this.visitLdcInsn(value);
                }
            }
        }
    }

    public void push(Handle handle) {
        this.mv.visitLdcInsn(handle);
    }

    private int getArgIndex(int arg) {
        int index = (this.access & 8) == 0 ? 1 : 0;
        for (int i = 0; i < arg; ++i) {
            index += this.argumentTypes[i].getSize();
        }
        return index;
    }

    private void loadInsn(Type type, int index) {
        this.visitVarInsn(type.getOpcode(21), index);
    }

    private void storeInsn(Type type, int index) {
        this.visitVarInsn(type.getOpcode(54), index);
    }

    public void loadThis() {
        if ((this.access & 8) != 0) {
            throw new IllegalStateException("no 'this' pointer within static method");
        }
        this.visitVarInsn(25, 0);
    }

    public void loadArg(int arg) {
        this.loadInsn(this.argumentTypes[arg], this.getArgIndex(arg));
    }

    public void loadArgs(int arg, int count) {
        int index = this.getArgIndex(arg);
        for (int i = 0; i < count; ++i) {
            Type t = this.argumentTypes[arg + i];
            this.loadInsn(t, index);
            index += t.getSize();
        }
    }

    public void loadArgs() {
        this.loadArgs(0, this.argumentTypes.length);
    }

    public void loadArgArray() {
        this.push(this.argumentTypes.length);
        this.newArray(OBJECT_TYPE);
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            this.dup();
            this.push(i);
            this.loadArg(i);
            this.box(this.argumentTypes[i]);
            this.arrayStore(OBJECT_TYPE);
        }
    }

    public void storeArg(int arg) {
        this.storeInsn(this.argumentTypes[arg], this.getArgIndex(arg));
    }

    public void arrayLoad(Type type) {
        this.visitInsn(type.getOpcode(46));
    }

    public void arrayStore(Type type) {
        this.visitInsn(type.getOpcode(79));
    }

    public void pop() {
        this.visitInsn(87);
    }

    public void pop2() {
        this.visitInsn(88);
    }

    public void dup() {
        this.visitInsn(89);
    }

    public void dup2() {
        this.visitInsn(92);
    }

    public void dupX1() {
        this.visitInsn(90);
    }

    public void dupX2() {
        this.visitInsn(91);
    }

    public void dup2X1() {
        this.visitInsn(93);
    }

    public void dup2X2() {
        this.visitInsn(94);
    }

    public void swap() {
        this.visitInsn(95);
    }

    public void swap(Type prev, Type type) {
        if (type.getSize() == 1) {
            if (prev.getSize() == 1) {
                this.swap();
            } else {
                this.dupX2();
                this.pop();
            }
        } else if (prev.getSize() == 1) {
            this.dup2X1();
            this.pop2();
        } else {
            this.dup2X2();
            this.pop2();
        }
    }

    public void math(int op, Type type) {
        this.visitInsn(type.getOpcode(op));
    }

    public void not() {
        this.visitInsn(4);
        this.visitInsn(130);
    }

    public void iinc(int local, int amount) {
        this.visitIincInsn(local, amount);
    }

    public void cast(Type from, Type to) {
        if (from != to) {
            if (from == Type.DOUBLE_TYPE) {
                if (to == Type.FLOAT_TYPE) {
                    this.visitInsn(144);
                } else if (to == Type.LONG_TYPE) {
                    this.visitInsn(143);
                } else {
                    this.visitInsn(142);
                    this.cast(Type.INT_TYPE, to);
                }
            } else if (from == Type.FLOAT_TYPE) {
                if (to == Type.DOUBLE_TYPE) {
                    this.visitInsn(141);
                } else if (to == Type.LONG_TYPE) {
                    this.visitInsn(140);
                } else {
                    this.visitInsn(139);
                    this.cast(Type.INT_TYPE, to);
                }
            } else if (from == Type.LONG_TYPE) {
                if (to == Type.DOUBLE_TYPE) {
                    this.visitInsn(138);
                } else if (to == Type.FLOAT_TYPE) {
                    this.visitInsn(137);
                } else {
                    this.visitInsn(136);
                    this.cast(Type.INT_TYPE, to);
                }
            } else if (to == Type.BYTE_TYPE) {
                this.visitInsn(145);
            } else if (to == Type.CHAR_TYPE) {
                this.visitInsn(146);
            } else if (to == Type.DOUBLE_TYPE) {
                this.visitInsn(135);
            } else if (to == Type.FLOAT_TYPE) {
                this.visitInsn(134);
            } else if (to == Type.LONG_TYPE) {
                this.visitInsn(133);
            } else if (to == Type.SHORT_TYPE) {
                this.visitInsn(147);
            }
        }
    }

    public void box(Type type) {
        if (type.getSort() == 10 || type.getSort() == 9) {
            return;
        }
        if (type == Type.VOID_TYPE) {
            this.push((String)null);
        } else {
            Type boxed = type;
            switch (type.getSort()) {
                case 3: {
                    boxed = BYTE_TYPE;
                    break;
                }
                case 1: {
                    boxed = BOOLEAN_TYPE;
                    break;
                }
                case 4: {
                    boxed = SHORT_TYPE;
                    break;
                }
                case 2: {
                    boxed = CHARACTER_TYPE;
                    break;
                }
                case 5: {
                    boxed = INTEGER_TYPE;
                    break;
                }
                case 6: {
                    boxed = FLOAT_TYPE;
                    break;
                }
                case 7: {
                    boxed = LONG_TYPE;
                    break;
                }
                case 8: {
                    boxed = DOUBLE_TYPE;
                }
            }
            this.newInstance(boxed);
            if (type.getSize() == 2) {
                this.dupX2();
                this.dupX2();
                this.pop();
            } else {
                this.dupX1();
                this.swap();
            }
            this.invokeConstructor(boxed, new Method("<init>", Type.VOID_TYPE, new Type[]{type}));
        }
    }

    public void unbox(Type type) {
        Type t = NUMBER_TYPE;
        Method sig = null;
        switch (type.getSort()) {
            case 0: {
                return;
            }
            case 2: {
                t = CHARACTER_TYPE;
                sig = CHAR_VALUE;
                break;
            }
            case 1: {
                t = BOOLEAN_TYPE;
                sig = BOOLEAN_VALUE;
                break;
            }
            case 8: {
                sig = DOUBLE_VALUE;
                break;
            }
            case 6: {
                sig = FLOAT_VALUE;
                break;
            }
            case 7: {
                sig = LONG_VALUE;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                sig = INT_VALUE;
            }
        }
        if (sig == null) {
            this.checkCast(type);
        } else {
            this.checkCast(t);
            this.invokeVirtual(t, sig);
        }
    }

    public Label newLabel() {
        return new Label();
    }

    public void mark(Label label) {
        this.visitLabel(label);
    }

    public Label mark() {
        Label label = new Label();
        this.visitLabel(label);
        return label;
    }

    public void ifCmp(Type type, int mode, Label label) {
        int intOp = -1;
        switch (type.getSort()) {
            case 7: {
                this.visitInsn(148);
                break;
            }
            case 8: {
                this.visitInsn(152);
                break;
            }
            case 6: {
                this.visitInsn(150);
                break;
            }
            case 9: 
            case 10: {
                switch (mode) {
                    case 153: {
                        this.visitJumpInsn(165, label);
                        return;
                    }
                    case 154: {
                        this.visitJumpInsn(166, label);
                        return;
                    }
                }
                throw new IllegalArgumentException("Bad comparison for type " + type);
            }
            default: {
                switch (mode) {
                    case 153: {
                        intOp = 159;
                        break;
                    }
                    case 154: {
                        intOp = 160;
                        break;
                    }
                    case 156: {
                        intOp = 162;
                        break;
                    }
                    case 155: {
                        intOp = 161;
                        break;
                    }
                    case 158: {
                        intOp = 164;
                        break;
                    }
                    case 157: {
                        intOp = 163;
                    }
                }
                this.visitJumpInsn(intOp, label);
                return;
            }
        }
        int jumpMode = mode;
        switch (mode) {
            case 156: {
                jumpMode = 155;
                break;
            }
            case 158: {
                jumpMode = 157;
            }
        }
        this.visitJumpInsn(jumpMode, label);
    }

    public void ifICmp(int mode, Label label) {
        this.ifCmp(Type.INT_TYPE, mode, label);
    }

    public void ifZCmp(int mode, Label label) {
        this.visitJumpInsn(mode, label);
    }

    public void ifNull(Label label) {
        this.visitJumpInsn(198, label);
    }

    public void ifNonNull(Label label) {
        this.visitJumpInsn(199, label);
    }

    public void goTo(Label label) {
        this.visitJumpInsn(167, label);
    }

    public void ret(int local) {
        this.visitVarInsn(169, local);
    }

    public void tableSwitch(int[] keys, TableSwitchGenerator generator) {
        float density = keys.length == 0 ? 0.0f : (float)keys.length / (float)(keys[keys.length - 1] - keys[0] + 1);
        this.tableSwitch(keys, generator, density >= 0.5f);
    }

    public void tableSwitch(int[] keys, TableSwitchGenerator generator, boolean useTable) {
        for (int i = 1; i < keys.length; ++i) {
            if (keys[i] >= keys[i - 1]) continue;
            throw new IllegalArgumentException("keys must be sorted ascending");
        }
        Label def = this.newLabel();
        Label end = this.newLabel();
        if (keys.length > 0) {
            int len = keys.length;
            int min = keys[0];
            int max = keys[len - 1];
            int range = max - min + 1;
            if (useTable) {
                int i;
                Object[] labels = new Label[range];
                Arrays.fill(labels, def);
                for (i = 0; i < len; ++i) {
                    labels[keys[i] - min] = this.newLabel();
                }
                this.visitTableSwitchInsn(min, max, def, (Label[])labels);
                for (i = 0; i < range; ++i) {
                    Object label = labels[i];
                    if (label == def) continue;
                    this.mark((Label)label);
                    generator.generateCase(i + min, end);
                }
            } else {
                int i;
                Label[] labels = new Label[len];
                for (i = 0; i < len; ++i) {
                    labels[i] = this.newLabel();
                }
                this.visitLookupSwitchInsn(def, keys, labels);
                for (i = 0; i < len; ++i) {
                    this.mark(labels[i]);
                    generator.generateCase(keys[i], end);
                }
            }
        }
        this.mark(def);
        generator.generateDefault();
        this.mark(end);
    }

    public void returnValue() {
        this.visitInsn(this.returnType.getOpcode(172));
    }

    private void fieldInsn(int opcode, Type ownerType, String name, Type fieldType) {
        this.visitFieldInsn(opcode, ownerType.getInternalName(), name, fieldType.getDescriptor());
    }

    public void getStatic(Type owner, String name, Type type) {
        this.fieldInsn(178, owner, name, type);
    }

    public void putStatic(Type owner, String name, Type type) {
        this.fieldInsn(179, owner, name, type);
    }

    public void getField(Type owner, String name, Type type) {
        this.fieldInsn(180, owner, name, type);
    }

    public void putField(Type owner, String name, Type type) {
        this.fieldInsn(181, owner, name, type);
    }

    private void invokeInsn(int opcode, Type type, Method method, boolean itf) {
        String owner = type.getSort() == 9 ? type.getDescriptor() : type.getInternalName();
        this.visitMethodInsn(opcode, owner, method.getName(), method.getDescriptor(), itf);
    }

    public void invokeVirtual(Type owner, Method method) {
        this.invokeInsn(182, owner, method, false);
    }

    public void invokeConstructor(Type type, Method method) {
        this.invokeInsn(183, type, method, false);
    }

    public void invokeStatic(Type owner, Method method) {
        this.invokeInsn(184, owner, method, false);
    }

    public void invokeInterface(Type owner, Method method) {
        this.invokeInsn(185, owner, method, true);
    }

    public void invokeDynamic(String name, String desc, Handle bsm, Object ... bsmArgs) {
        this.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
    }

    private void typeInsn(int opcode, Type type) {
        String desc = type.getSort() == 9 ? type.getDescriptor() : type.getInternalName();
        this.visitTypeInsn(opcode, desc);
    }

    public void newInstance(Type type) {
        this.typeInsn(187, type);
    }

    public void newArray(Type type) {
        int typ;
        switch (type.getSort()) {
            case 1: {
                typ = 4;
                break;
            }
            case 2: {
                typ = 5;
                break;
            }
            case 3: {
                typ = 8;
                break;
            }
            case 4: {
                typ = 9;
                break;
            }
            case 5: {
                typ = 10;
                break;
            }
            case 6: {
                typ = 6;
                break;
            }
            case 7: {
                typ = 11;
                break;
            }
            case 8: {
                typ = 7;
                break;
            }
            default: {
                this.typeInsn(189, type);
                return;
            }
        }
        this.visitIntInsn(188, typ);
    }

    public void arrayLength() {
        this.visitInsn(190);
    }

    public void throwException() {
        this.visitInsn(191);
    }

    public void throwException(Type type, String msg) {
        this.newInstance(type);
        this.dup();
        this.push(msg);
        this.invokeConstructor(type, Method.getMethod("void <init> (String)"));
        this.throwException();
    }

    public void checkCast(Type type) {
        if (!type.equals(OBJECT_TYPE)) {
            this.typeInsn(192, type);
        }
    }

    public void instanceOf(Type type) {
        this.typeInsn(193, type);
    }

    public void monitorEnter() {
        this.visitInsn(194);
    }

    public void monitorExit() {
        this.visitInsn(195);
    }

    public void endMethod() {
        if ((this.access & 0x400) == 0) {
            this.visitMaxs(0, 0);
        }
        this.visitEnd();
    }

    public void catchException(Label start, Label end, Type exception) {
        if (exception == null) {
            this.visitTryCatchBlock(start, end, this.mark(), null);
        } else {
            this.visitTryCatchBlock(start, end, this.mark(), exception.getInternalName());
        }
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        if (var >= this.nextLocal || this.localTypes.get(var) == null) {
            int size = 1;
            Type type = null;
            switch (opcode) {
                case 54: {
                    type = Type.INT_TYPE;
                    break;
                }
                case 55: {
                    type = Type.LONG_TYPE;
                    size = 2;
                    break;
                }
                case 56: {
                    type = Type.FLOAT_TYPE;
                    break;
                }
                case 57: {
                    type = Type.DOUBLE_TYPE;
                    size = 2;
                    break;
                }
                case 58: {
                    type = Type.getType(Object.class);
                }
            }
            if (var < this.nextLocal) {
                this.localTypes.set(var, type);
            } else {
                for (int i = this.nextLocal; i < var; ++i) {
                    this.localTypes.add(null);
                }
                this.localTypes.add(type);
                if (size > 1) {
                    this.localTypes.add(null);
                }
                this.nextLocal = var + size;
                if (this.nextLocal > this.localHighWater) {
                    this.localHighWater = this.nextLocal;
                }
            }
        }
        super.visitVarInsn(opcode, var);
    }

    public int newLocal(Type valueType) {
        int localIndex = this.nextLocal++;
        this.localTypes.add(valueType);
        if (valueType.getSize() > 1) {
            ++this.nextLocal;
            this.localTypes.add(null);
        }
        if (this.nextLocal > this.localHighWater) {
            this.localHighWater = this.nextLocal;
        }
        return localIndex;
    }

    public void popLocal(int local) {
        Type type = (Type)this.localTypes.get(local);
        int size = type.getSize();
        if (this.nextLocal != local + size) {
            throw new IndexOutOfBoundsException("popLocal was expecting " + (this.nextLocal - size) + " but got " + local + " instead!");
        }
        if (size > 1) {
            --this.nextLocal;
            this.localTypes.remove(this.nextLocal);
        }
        --this.nextLocal;
        this.localTypes.remove(this.nextLocal);
    }

    public void loadLocal(int local) {
        Type type = (Type)this.localTypes.get(local);
        this.visitVarInsn(type.getOpcode(21), local);
    }

    public void storeLocal(int local) {
        Type type = (Type)this.localTypes.get(local);
        this.visitVarInsn(type.getOpcode(54), local);
    }

    public Type getLocalType(int local) {
        return (Type)this.localTypes.get(local);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        if (this.localHighWater < maxLocals) {
            this.localHighWater = maxLocals;
        }
        this.mv.visitMaxs(maxStack, this.localHighWater);
    }

    private void dumpFrame(int nLocal, Object[] local, int nStack, Object[] stack) {
        int i;
        StringBuffer buffer = new StringBuffer();
        Label l = new Label();
        this.visitLabel(l);
        buffer.append("Frame ");
        buffer.append(l.getOffset());
        buffer.append("\n");
        buffer.append("  locals ");
        buffer.append(nLocal);
        buffer.append("\n    ");
        String sepr = "";
        for (i = 0; i < nLocal; ++i) {
            buffer.append(sepr);
            this.dumpType(buffer, local[i]);
            sepr = ",\n    ";
        }
        buffer.append("\n  stack ");
        buffer.append(nStack);
        buffer.append("\n    ");
        sepr = "";
        for (i = 0; i < nStack; ++i) {
            buffer.append(sepr);
            this.dumpType(buffer, stack[i]);
            sepr = ",\n    ";
        }
        System.out.println(buffer.toString());
    }

    private void dumpType(StringBuffer buffer, Object t) {
        if (t == Opcodes.TOP) {
            buffer.append("TOP");
        } else if (t == null) {
            buffer.append("null");
        } else if (t == Opcodes.INTEGER) {
            buffer.append("int");
        } else if (t == Opcodes.FLOAT) {
            buffer.append("float");
        } else if (t == Opcodes.DOUBLE) {
            buffer.append("double");
        } else if (t == Opcodes.LONG) {
            buffer.append("long");
        } else if (t == Opcodes.NULL) {
            buffer.append("null");
        } else if (t == Opcodes.UNINITIALIZED_THIS) {
            buffer.append("uninit_this");
        } else if (t instanceof String) {
            buffer.append((String)t);
        } else {
            buffer.append(((Label)t).getOffset());
        }
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        int toRemove;
        if (type != -1) {
            throw new IllegalStateException("ClassReader.accept() should be called with EXPAND_FRAMES flag");
        }
        for (int i = toRemove = this.localTypes.size(); i > 0; --i) {
            this.localTypes.remove(i - 1);
        }
        int nextLocal = 0;
        for (int i = 0; i < nLocal; ++i) {
            Object t = local[i];
            if (t == Opcodes.TOP) {
                this.localTypes.add(null);
            } else if (t == null) {
                this.localTypes.add(null);
            } else if (t == Opcodes.INTEGER) {
                this.localTypes.add(Type.INT_TYPE);
            } else if (t == Opcodes.FLOAT) {
                this.localTypes.add(Type.FLOAT_TYPE);
            } else if (t == Opcodes.DOUBLE) {
                this.localTypes.add(Type.DOUBLE_TYPE);
                ++nextLocal;
                this.localTypes.add(null);
            } else if (t == Opcodes.LONG) {
                this.localTypes.add(Type.LONG_TYPE);
                ++nextLocal;
                this.localTypes.add(null);
            } else if (t == Opcodes.NULL) {
                this.localTypes.add(null);
            } else if (t == Opcodes.UNINITIALIZED_THIS) {
                this.localTypes.add(null);
            } else if (t instanceof String) {
                this.localTypes.add(Type.getObjectType((String)t));
            } else {
                this.localTypes.add(null);
            }
            ++nextLocal;
        }
        this.nextLocal = nextLocal;
        this.mv.visitFrame(type, nLocal, local, nStack, stack);
    }
}

