/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.internal.actions;

import java.util.ArrayList;
import java.util.Map;
import org.hawkular.btm.api.internal.actions.ExpressionBasedActionHandler;
import org.hawkular.btm.api.model.Severity;
import org.hawkular.btm.api.model.config.Direction;
import org.hawkular.btm.api.model.config.btxn.Processor;
import org.hawkular.btm.api.model.config.btxn.ProcessorAction;
import org.hawkular.btm.api.model.config.btxn.SetDetailAction;
import org.hawkular.btm.api.model.trace.Issue;
import org.hawkular.btm.api.model.trace.Node;
import org.hawkular.btm.api.model.trace.ProcessorIssue;
import org.hawkular.btm.api.model.trace.Trace;

public class SetDetailActionHandler
extends ExpressionBasedActionHandler {
    private static final String NAME_MUST_BE_SPECIFIED = "Name must be specified";

    public SetDetailActionHandler(ProcessorAction action) {
        super(action);
    }

    @Override
    public void init(Processor processor) {
        super.init(processor);
        SetDetailAction action = (SetDetailAction)this.getAction();
        if (action.getName() == null || action.getName().trim().length() == 0) {
            ProcessorIssue pi = new ProcessorIssue();
            pi.setProcessor(processor.getDescription());
            pi.setAction(this.getAction().getDescription());
            pi.setField("name");
            pi.setSeverity(Severity.Error);
            pi.setDescription(NAME_MUST_BE_SPECIFIED);
            if (this.getIssues() == null) {
                this.setIssues(new ArrayList<Issue>());
            }
            this.getIssues().add(0, pi);
        }
    }

    @Override
    public boolean process(Trace trace, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        String value;
        if (super.process(trace, node, direction, headers, values) && (value = this.getValue(trace, node, direction, headers, values)) != null && ((SetDetailAction)this.getAction()).getName() != null) {
            node.getDetails().put(((SetDetailAction)this.getAction()).getName(), value);
            return true;
        }
        return false;
    }
}

