/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.model.analytics;

import java.util.HashMap;
import java.util.Map;

public class CommunicationSummaryStatistics {
    private String id;
    private long minimumDuration;
    private long averageDuration;
    private long maximumDuration;
    private long count;
    private int severity = 0;
    private Map<String, ConnectionStatistics> outbound = new HashMap<String, ConnectionStatistics>();

    public CommunicationSummaryStatistics() {
    }

    public CommunicationSummaryStatistics(CommunicationSummaryStatistics node) {
        this.id = node.id;
        this.minimumDuration = node.minimumDuration;
        this.averageDuration = node.averageDuration;
        this.maximumDuration = node.maximumDuration;
        this.count = node.count;
        this.severity = node.severity;
        for (String id : node.getOutbound().keySet()) {
            this.outbound.put(id, new ConnectionStatistics(node.getOutbound().get(id)));
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getMinimumDuration() {
        return this.minimumDuration;
    }

    public void setMinimumDuration(long minimumDuration) {
        this.minimumDuration = minimumDuration;
    }

    public long getAverageDuration() {
        return this.averageDuration;
    }

    public void setAverageDuration(long averageDuration) {
        this.averageDuration = averageDuration;
    }

    public long getMaximumDuration() {
        return this.maximumDuration;
    }

    public void setMaximumDuration(long maximumDuration) {
        this.maximumDuration = maximumDuration;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public Map<String, ConnectionStatistics> getOutbound() {
        return this.outbound;
    }

    public void setOutbound(Map<String, ConnectionStatistics> outbound) {
        this.outbound = outbound;
    }

    public String toString() {
        return "CommunicationSummaryStatistics [id=" + this.id + ", minimumDuration=" + this.minimumDuration + ", averageDuration=" + this.averageDuration + ", maximumDuration=" + this.maximumDuration + ", count=" + this.count + ", severity=" + this.severity + ", outbound=" + this.outbound + "]";
    }

    public static class ConnectionStatistics {
        private long minimumLatency;
        private long averageLatency;
        private long maximumLatency;
        private long count;
        private int severity = 0;
        private CommunicationSummaryStatistics node;

        public ConnectionStatistics() {
        }

        public ConnectionStatistics(ConnectionStatistics cs) {
            this.minimumLatency = cs.minimumLatency;
            this.averageLatency = cs.averageLatency;
            this.maximumLatency = cs.maximumLatency;
            this.count = cs.count;
            this.severity = cs.severity;
            if (cs.node != null) {
                this.node = new CommunicationSummaryStatistics(cs.node);
            }
        }

        public long getMinimumLatency() {
            return this.minimumLatency;
        }

        public void setMinimumLatency(long minimumLatency) {
            this.minimumLatency = minimumLatency;
        }

        public long getAverageLatency() {
            return this.averageLatency;
        }

        public void setAverageLatency(long averageLatency) {
            this.averageLatency = averageLatency;
        }

        public long getMaximumLatency() {
            return this.maximumLatency;
        }

        public void setMaximumLatency(long maximumLatency) {
            this.maximumLatency = maximumLatency;
        }

        public long getCount() {
            return this.count;
        }

        public void setCount(long count) {
            this.count = count;
        }

        public int getSeverity() {
            return this.severity;
        }

        public void setSeverity(int severity) {
            this.severity = severity;
        }

        public CommunicationSummaryStatistics getNode() {
            return this.node;
        }

        public void setNode(CommunicationSummaryStatistics node) {
            this.node = node;
        }

        public String toString() {
            return "ConnectionStatistics [minimumLatency=" + this.minimumLatency + ", averageLatency=" + this.averageLatency + ", maximumLatency=" + this.maximumLatency + ", count=" + this.count + ", severity=" + this.severity + ", node=" + this.node + "]";
        }
    }
}

