/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.model.trace;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hawkular.btm.api.model.trace.CorrelationIdentifier;
import org.hawkular.btm.api.model.trace.Node;

public class Trace {
    @JsonInclude
    private String id;
    @JsonInclude
    private long startTime;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String businessTransaction;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String principal;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String hostName;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String hostAddress;
    @JsonInclude
    private List<Node> nodes = new ArrayList<Node>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> properties = new HashMap<String, String>();

    public String getId() {
        return this.id;
    }

    public Trace setId(String id) {
        this.id = id;
        return this;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Trace setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public String getBusinessTransaction() {
        return this.businessTransaction;
    }

    public Trace setBusinessTransaction(String name) {
        this.businessTransaction = name;
        return this;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public Trace setPrincipal(String principal) {
        this.principal = principal;
        return this;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Trace setHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public Trace setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
        return this;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public Trace setNodes(List<Node> nodes) {
        this.nodes = nodes;
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Trace setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public boolean initialFragment() {
        return !this.getNodes().isEmpty() && this.getNodes().get(0).getCorrelationIds(CorrelationIdentifier.Scope.Interaction).isEmpty();
    }

    public long endTime() {
        return this.getStartTime() + this.calculateDuration();
    }

    public long calculateDuration() {
        if (!this.nodes.isEmpty()) {
            long endTimeNS = 0L;
            for (int i = 0; i < this.getNodes().size(); ++i) {
                Node node = this.getNodes().get(i);
                long et = node.overallEndTime();
                if (et <= endTimeNS) continue;
                endTimeNS = et;
            }
            long elapsedTime = endTimeNS - this.getNodes().get(0).getBaseTime();
            return TimeUnit.MILLISECONDS.convert(elapsedTime, TimeUnit.NANOSECONDS);
        }
        return 0L;
    }

    public Set<Node> getCorrelatedNodes(CorrelationIdentifier cid) {
        HashSet<Node> ret = new HashSet<Node>();
        for (Node n : this.getNodes()) {
            n.findCorrelatedNodes(cid, ret);
        }
        return ret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hostAddress == null ? 0 : this.hostAddress.hashCode());
        result = 31 * result + (this.hostName == null ? 0 : this.hostName.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.businessTransaction == null ? 0 : this.businessTransaction.hashCode());
        result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
        result = 31 * result + (this.principal == null ? 0 : this.principal.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Trace other = (Trace)obj;
        if (this.hostAddress == null ? other.hostAddress != null : !this.hostAddress.equals(other.hostAddress)) {
            return false;
        }
        if (this.hostName == null ? other.hostName != null : !this.hostName.equals(other.hostName)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.businessTransaction == null ? other.businessTransaction != null : !this.businessTransaction.equals(other.businessTransaction)) {
            return false;
        }
        if (this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes)) {
            return false;
        }
        if (this.principal == null ? other.principal != null : !this.principal.equals(other.principal)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return this.startTime == other.startTime;
    }

    public String toString() {
        return "Trace [id=" + this.id + ", startTime=" + this.startTime + ", businessTransaction=" + this.businessTransaction + ", principal=" + this.principal + ", hostName=" + this.hostName + ", hostAddress=" + this.hostAddress + ", nodes=" + this.nodes + ", properties=" + this.properties + "]";
    }
}

