/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hawkular.btm.api.internal.actions.ProcessorActionHandler;
import org.hawkular.btm.api.internal.actions.ProcessorActionHandlerFactory;
import org.hawkular.btm.api.model.config.btxn.BusinessTxnConfig;
import org.hawkular.btm.api.model.config.btxn.ConfigMessage;
import org.hawkular.btm.api.model.config.btxn.Processor;
import org.hawkular.btm.api.model.config.btxn.ProcessorAction;
import org.hawkular.btm.api.model.trace.Issue;
import org.hawkular.btm.api.model.trace.ProcessorIssue;
import org.hawkular.btm.api.services.ConfigurationService;

public abstract class AbstractConfigurationService
implements ConfigurationService {
    private static final String NO_FILTERS = "No inclusion or exclusion filters have been defined";

    @Override
    public List<ConfigMessage> validateBusinessTransaction(BusinessTxnConfig config) {
        ArrayList<ConfigMessage> messages = new ArrayList<ConfigMessage>();
        if (config.getFilter() == null || config.getFilter().getInclusions().isEmpty() && config.getFilter().getInclusions().isEmpty()) {
            ConfigMessage cm = new ConfigMessage();
            cm.setMessage(NO_FILTERS);
            messages.add(cm);
        }
        for (Processor processor : config.getProcessors()) {
            for (ProcessorAction action : processor.getActions()) {
                ProcessorActionHandler handler = ProcessorActionHandlerFactory.getHandler(action);
                if (handler == null) continue;
                handler.init(processor);
                if (handler.getIssues() == null) continue;
                for (Issue issue : handler.getIssues()) {
                    ConfigMessage cm = new ConfigMessage();
                    cm.setMessage(issue.getDescription());
                    if (issue instanceof ProcessorIssue) {
                        cm.setProcessor(((ProcessorIssue)issue).getProcessor());
                        cm.setAction(((ProcessorIssue)issue).getAction());
                        cm.setField(((ProcessorIssue)issue).getField());
                    }
                    cm.setSeverity(issue.getSeverity());
                    messages.add(cm);
                }
            }
        }
        return messages;
    }

    @Override
    public List<ConfigMessage> setBusinessTransactions(String tenantId, Map<String, BusinessTxnConfig> configs) throws Exception {
        ArrayList<ConfigMessage> messages = new ArrayList<ConfigMessage>();
        for (String name : configs.keySet()) {
            messages.addAll(this.setBusinessTransaction(tenantId, name, configs.get(name)));
        }
        return messages;
    }
}

