/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.utils;

import org.hawkular.btm.api.logging.Logger;

public class PropertyUtil {
    private static final Logger LOG = Logger.getLogger(PropertyUtil.class.getName());
    public static final String HAWKULAR_APM_URI = "HAWKULAR_APM_URI";
    public static final String HAWKULAR_APM_USERNAME = "HAWKULAR_APM_USERNAME";
    public static final String HAWKULAR_APM_PASSWORD = "HAWKULAR_APM_PASSWORD";
    public static final String HAWKULAR_APM_CONFIG_REFRESH = "HAWKULAR_APM_CONFIG_REFRESH";

    public static String getProperty(String name) {
        return System.getProperty(name, System.getenv(name));
    }

    public static String getProperty(String name, String def) {
        String ret = System.getProperty(name, System.getenv(name));
        if (ret != null) {
            return ret;
        }
        return def;
    }

    public static Integer getPropertyAsInteger(String name) {
        String value = PropertyUtil.getProperty(name);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                LOG.log(Logger.Level.WARNING, "Failed to convert property value '" + value + "' to integer", e);
            }
        }
        return null;
    }

    public static boolean getPropertyAsBoolean(String name) {
        String value = PropertyUtil.getProperty(name);
        return value != null && value.equalsIgnoreCase("true");
    }
}

